//: c13:Restaurant.java
// Wspdziaanie wtkw opate na modelu producent-konsument.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Order {
  private static int i = 0;
  private int count = i++;
  public Order() {
    if(count == 10) {
      System.out.println("Brak skadnikw, zamykamy");
      System.exit(0);
    }
  }
  public String toString() { return "Zamwienie " + count; }
}

class WaitPerson extends Thread {
  private Restaurant restaurant;
  public WaitPerson(Restaurant r) {
    restaurant = r;
    start();
  }
  public void run() {
    while(true) {
      while(restaurant.order == null)
        synchronized(this) {
          try {
            wait();
          } catch(InterruptedException e) {
            throw new RuntimeException(e);
          }
        }
      System.out.println(
        "Kelner otrzyma Zamwienie " + restaurant.order);
      restaurant.order = null;
    }
  }
}

class Chef extends Thread {
  private Restaurant restaurant;
  private WaitPerson waitPerson;
  public Chef(Restaurant r, WaitPerson w) {
    restaurant = r;
    waitPerson = w;
    start();
  }
  public void run() {
    while(true) {
      if(restaurant.order == null) {
        restaurant.order = new Order();
        System.out.print("Zamwienie! ");
        synchronized(waitPerson) {
          waitPerson.notify();
        }
      }
      try {
        sleep(100);
      } catch(InterruptedException e) {
        throw new RuntimeException(e);
      }
    }
  }
}

public class Restaurant {
  private static Test monitor = new Test();
  Order order; // Dostp pakietowy
  public static void main(String[] args) {
    Restaurant restaurant = new Restaurant();
    WaitPerson waitPerson = new WaitPerson(restaurant);
    Chef chef = new Chef(restaurant, waitPerson);
    monitor.expect(new String[] {
      "Zamwienie! Kelner otrzyma Zamwienie 0",
      "Zamwienie! Kelner otrzyma Zamwienie 1",
      "Zamwienie! Kelner otrzyma Zamwienie 2",
      "Zamwienie! Kelner otrzyma Zamwienie 3",
      "Zamwienie! Kelner otrzyma Zamwienie 4",
      "Zamwienie! Kelner otrzyma Zamwienie 5",
      "Zamwienie! Kelner otrzyma Zamwienie 6",
      "Zamwienie! Kelner otrzyma Zamwienie 7",
      "Zamwienie! Kelner otrzyma Zamwienie 8",
      "Zamwienie! Kelner otrzyma Zamwienie 9",
      "Brak skadnikw, zamykamy"
    }, Test.WAIT);
  }
} ///:~
