//: c13:InvariantWatcher.java
// Cyklicznie sprawdza czy nie zosta zaburzony niezmiennik obiektu
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.

public class InvariantWatcher extends Thread {
  private Invariant invariant;
  public InvariantWatcher(Invariant invariant) {
    this.invariant = invariant;
    setDaemon(true);
    start();
  }
  // Po chwili zatrzymaj wszystko
  public
  InvariantWatcher(Invariant invariant, final int timeOut){
    this(invariant);
    new Timeout(timeOut,
      "Czas upyn, niezmiennik nie zosta zaburzony.");
  }
  public void run() {
    while(true) {
      InvariantState state = invariant.invariant();
      if(state instanceof InvariantFailure) {
        System.out.println("Niezmiennik zaburzony: "
          + ((InvariantFailure)state).value);
        System.exit(0);
      }
    }
  }
} ///:~
