//: c12:SplitDemo.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.regex.*;
import com.bruceeckel.simpletest.*;
import java.util.*;

public class SplitDemo {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    String input =
      "Oto!!niezwyky sposb!!wykorzystania!!wykrzyknikw";
    System.out.println(Arrays.asList(
      Pattern.compile("!!").split(input)));
    // Uwzgldniane s tylko pierwsze trzy:
    System.out.println(Arrays.asList(
      Pattern.compile("!!").split(input, 3)));
    System.out.println(Arrays.asList(
      "Metoda split() jest te dostpna w klasie String!".split(" ")));
    monitor.expect(new String[] {
      "[Oto, niezwyky sposb, wykorzystania, wykrzyknikw]",
      "[Oto, niezwyky sposb, wykorzystania!!wykrzyknikw]",
      "[Metoda, split(), jest, te, dostpna, w, klasie, String!]"
    });
  }
} ///:~
