//: c12:Logon.java
// Zastosowanie sowa kluczowego transient.
// {Porzdki: Logon.out}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.io.*;
import java.util.*;

public class Logon implements Serializable {
  private Date date = new Date();
  private String username;
  private transient String password;
  public Logon(String name, String pwd) {
    username = name;
    password = pwd;
  }
  public String toString() {
    String pwd = (password == null) ? "(brak)" : password;
    return "informacje: \n   uytkownik: " + username +
      "\n   data: " + date + "\n   haso: " + pwd;
  }
  public static void main(String[] args) throws Exception {
    Logon a = new Logon("Kolos", "mojMalyKonik");
    System.out.println( "logon a = " + a);
    ObjectOutputStream o = new ObjectOutputStream(
      new FileOutputStream("Logon.out"));
    o.writeObject(a);
    o.close();
    Thread.sleep(1000); // Opnienie o 1 sekund
    // A teraz odzyskujemy je:
    ObjectInputStream in = new ObjectInputStream(
      new FileInputStream("Logon.out"));
    System.out.println("Odtwarzanie obiektu, czas "+new Date());
    a = (Logon)in.readObject();
    System.out.println("logowanie = " + a);
  }
} ///:~