//: c12:IntBufferDemo.java
// Operowanie na liczbach cakowitych w ByteBuffer 
// za porednictwem IntBuffer
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.nio.*;
import com.bruceeckel.simpletest.*;
import com.bruceeckel.util.*;

public class IntBufferDemo {
  private static Test monitor = new Test();
  private static final int BSIZE = 1024;
  public static void main(String[] args) {
    ByteBuffer bb = ByteBuffer.allocate(BSIZE);
    IntBuffer ib = bb.asIntBuffer();
    // Zapis tablicy liczb cakowitych:
    ib.put(new int[] { 11, 42, 47, 99, 143, 811, 1016 });
    // Odczyt i zapis liczby w konkretnym miejscu:
    System.out.println(ib.get(3));
    ib.put(3, 1811);
    ib.rewind();
    while(ib.hasRemaining()) {
      int i = ib.get();
      if(i == 0) break; // Inaczej cay bufor zostaby pobrany
      System.out.println(i);
    }
    monitor.expect(new String[] {
      "99",
      "11",
      "42",
      "47",
      "1811",
      "143",
      "811",
      "1016"
    });
  }
} ///:~