//: c12:GZIPcompress.java
// Wykorzystanie formatu GZIP do kompresji pliku 
// o nazwie przekazanej jako argument
// z wiersza polece.
// {Argumenty: GZIPcompress.java}
// {Porzdki: test.gz}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;
import java.util.zip.*;

public class GZIPcompress {
  private static Test monitor = new Test();
  // Komunikaty wyjtkw wypisywane s na konsol:
  public static void main(String[] args)
  throws IOException {
    if(args.length == 0) {
      System.out.println(
        "Sposb uycia: \nGZIPcompress plik\n" +
        "\tWykorzystuje kompresj GZIP do spakowania pliku " +
        "do pliku test.gz");
      System.exit(1);
    }
    BufferedInputStream in = new BufferedInputStream(
      new FileInputStream(args[0]));
    BufferedOutputStream out = new BufferedOutputStream(
      new GZIPOutputStream(
        new FileOutputStream("test.gz")));
    System.out.println("Zapis pliku");
    int c;
    while((c = in.read()) != -1)
      out.write(c);
    in.close();
    out.close();
    System.out.println("Odczyt pliku");
    BufferedReader in2 = new BufferedReader(
      new InputStreamReader(new GZIPInputStream(
        new FileInputStream("test.gz"))));
    String s;
    while((s = in2.readLine()) != null)
      System.out.println(s);
    monitor.expect(new String[] {
      "Zapis pliku",
      "Odczyt pliku"
    }, args[0]);
  }
} ///:~
