//: c12:BufferToText.java
// Konwersja tekstu na ByteBuffor oraz 
// zawartoci ByteBuffer na tekst
// {Porzdki: data2.txt}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;
import com.bruceeckel.simpletest.*;

public class BufferToText {
  private static Test monitor = new Test();
  private static final int BSIZE = 1024;
  public static void main(String[] args) throws Exception {
    FileChannel fc =
      new FileOutputStream("data2.txt").getChannel();
    fc.write(ByteBuffer.wrap("Oto tekst".getBytes()));
    fc.close();
    fc = new FileInputStream("data2.txt").getChannel();
    ByteBuffer buff = ByteBuffer.allocate(BSIZE);
    fc.read(buff);
    buff.flip();
    // To nie dziaa:
    System.out.println(buff.asCharBuffer());
    // Dekodowanie przy wykorzystaniu domylnego
    // systemowego zbioru znakw
    buff.rewind();
    String encoding = System.getProperty("file.encoding");
    System.out.println("Zdekodowano przy uyciu " + encoding + ": " 
      + Charset.forName(encoding).decode(buff));
    // Mona by take zakodowa przy uyciu czego 
    // co mona by wydrukowa:
    fc = new FileOutputStream("data2.txt").getChannel();
    fc.write(ByteBuffer.wrap(
      "Oto tekst".getBytes("UTF-16BE")));
    fc.close();
    // Prba ponownego odczytu:
    fc = new FileInputStream("data2.txt").getChannel();
    buff.clear();
    fc.read(buff);
    buff.flip();
    System.out.println(buff.asCharBuffer());
    // Wykorzystanie CharBuffer do zapisu:
    fc = new FileOutputStream("data2.txt").getChannel();
    buff = ByteBuffer.allocate(24); // Wicej ni potrzeba
    buff.asCharBuffer().put("Oto tekst");
    fc.write(buff);
    fc.close();
    // Odczyt i wywietlenie:
    fc = new FileInputStream("data2.txt").getChannel();
    buff.clear();
    fc.read(buff);
    buff.flip();
    System.out.println(buff.asCharBuffer());
    monitor.expect(new String[] {
      "????",
      "%% Zdekodowano przy uyciu [A-Za-z0-9_\\-]+: Oto tekst",
      "Oto tekst",
      "Oto tekst\0\0\0"
    });
  }
} ///:~