//: c10:ToyTest.java
// Badanie klasy Class.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

interface HasBatteries {}
interface Waterproof {}
interface Shoots {}
class Toy {
  // Zamie w komentarzu nastpujcy
  // konstruktor domylny, aby zobaczy bd
  // NoSuchMethodError w wierszu (*1*)
  Toy() {}
  Toy(int i) {}
}

class FancyToy extends Toy
implements HasBatteries, Waterproof, Shoots {
  FancyToy() { super(1); }
}

public class ToyTest {
  private static Test monitor = new Test();
  static void printInfo(Class cc) {
    System.out.println("Nazwa klasy: " + cc.getName() +
      " czy jest interfejsem? [" + cc.isInterface() + "]");
  }
  public static void main(String[] args) {
    Class c = null;
    try {
      c = Class.forName("FancyToy");
    } catch(ClassNotFoundException e) {
      System.err.println("Nie mona odnale FancyToy");
      System.exit(1);
    }
    printInfo(c);
    Class[] faces = c.getInterfaces();
    for(int i = 0; i < faces.length; i++)
      printInfo(faces[i]);
    Class cy = c.getSuperclass();
    Object o = null;
    try {
      // Wymaga konstruktora domylnego:
      o = cy.newInstance(); // (*1*)
    } catch(InstantiationException e) {
      System.err.println("Nie mona stworzy instancji");
      System.exit(1);
    } catch(IllegalAccessException e) {
      System.err.println("Nie ma dostpu");
      System.exit(1);
    }
    printInfo(o.getClass());
    monitor.expect(new String[] {
      "Nazwa klasy: FancyToy czy jest interfejsem? [false]",
      "Nazwa klasy: HasBatteries czy jest interfejsem? [true]",
      "Nazwa klasy: Waterproof czy jest interfejsem? [true]",
      "Nazwa klasy: Shoots czy jest interfejsem? [true]",
      "Nazwa klasy: Toy czy jest interfejsem? [false]"
    });
  }
} ///:~
