//: c09:StormyInning.java
// Metody przecione mog zgasza jedynie 
// wyjtki wyspecyfikowane w ich wersjach 
// z klasy bazowej lub wyjtki, ktre dziedzicz
// po wyjtkach klasy bazowej.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.

class BaseballException extends Exception {}
class Foul extends BaseballException {}
class Strike extends BaseballException {}

abstract class Inning {
  public Inning() throws BaseballException {}
  public void event() throws BaseballException {
    // Waciwie to nawet nic nie musi zgasza.
  }
  public abstract void atBat() throws Strike, Foul;
  public void walk() {} // Nie zgasza wyjtku sprawdzanego
}

class StormException extends Exception {}
class RainedOut extends StormException {}
class PopFoul extends Foul {}

interface Storm {
  public void event() throws RainedOut;
  public void rainHard() throws RainedOut;
}

public class StormyInning extends Inning implements Storm {
  // Mona doda nowe wyjtki do konstruktora, ale 
  // trzeba si trzyma wyjtkw konstruktora bazowego:
  public StormyInning() 
    throws RainedOut, BaseballException {}
  public StormyInning(String s) 
    throws Foul, BaseballException {}
  // Normalne metody musz by zgodne z klas bazow:
//! void walk() throws PopFoul {} //Bd kompilacji
  // Interfejsy NIE MOG dodawa wyjtkw do
  // metod istniejcych w klasie bazowej:
//! public void event() throws RainedOut {}
  // Mona doda wyjtek, jeli metoda nie 
  // istnieje jeszcze w klasie bazowej:
  public void rainHard() throws RainedOut {}
  // Mona zdecydowa, e nie bdzie zgaszany aden
  // wyjtek, nawet jeli wersja bazowa co zgasza:
  public void event() {}
  // Metody przecione mog zgasza przecione wyjtki:
  public void atBat() throws PopFoul {}
  public static void main(String[] args) {
    try {
      StormyInning si = new StormyInning();
      si.atBat();
    } catch(PopFoul e) {
      System.err.println("Pop foul");
    } catch(RainedOut e) {
      System.err.println("Rained out");
    } catch(BaseballException e) {
      System.err.println("Oglny wyjtek Baseball");
    }
    // Wyjtek Strike nie jest zgaszany w wersji przecionej.
    try {
      // Co si dzieje przy rzutowaniu na typ bazowy?
      Inning i = new StormyInning();
      i.atBat();
      // Trzeba przechwyci wyjtki z metody 
      // w wersji z klasy bazowej:
    } catch(Strike e) {
      System.err.println("Strike");
    } catch(Foul e) {
      System.err.println("Foul");
    } catch(RainedOut e) {
      System.err.println("Rained out");
    } catch(BaseballException e) {
      System.err.println("Oglny wyjtek baseball");
    }
  }
} ///:~