//: c09:RethrowNew.java
// Zgo inny wyjtek ni ten, ktry zosta przechwycony
// {Wykonanie programu powoduje zgoszenie wyjtku}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class OneException extends Exception {
  public OneException(String s) { super(s); }
}

class TwoException extends Exception {
  public TwoException(String s) { super(s); }
}

public class RethrowNew {
  private static Test monitor = new Test();
  public static void f() throws OneException {
    System.out.println("utworzenie wyjtku w metodzie f()");
    throw new OneException("zgoszony w metodzie f()");
  }
  public static void
  main(String[] args) throws TwoException {
    try {
      f();
    } catch(OneException e) {
      System.err.println(
        "Wyjtek przechwycony w metodzie main(), e.printStackTrace()");
      e.printStackTrace();
      throw new TwoException("zgoszony w metodzie main()");
    }
    monitor.expect(new String[] {
      "utworzenie wyjtku w metodzie f()",
      "Wyjtek przechwycony w metodzie main(), e.printStackTrace()",
      "OneException: zgoszony w metodzie f()",
      "\tat RethrowNew.f(RethrowNew.java:18)",
      "\tat RethrowNew.main(RethrowNew.java:22)",
      "Exception in thread \"main\" " +
      "TwoException: zgoszony w metodzie main()",
      "\tat RethrowNew.main(RethrowNew.java:28)"
    });
  }
} ///:~
