//: c08:nesting:NestingInterfaces.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
package c08.nesting;

class A {
  interface B {
    void f();
  }
  public class BImp implements B {
    public void f() {}
  }
  private class BImp2 implements B {
    public void f() {}
  }
  public interface C {
    void f();
  }
  class CImp implements C {
    public void f() {}
  }
  private class CImp2 implements C {
    public void f() {}
  }
  private interface D {
    void f();
  }
  private class DImp implements D {
    public void f() {}
  }
  public class DImp2 implements D {
    public void f() {}
  }
  public D getD() { return new DImp2(); }
  private D dRef;
  public void receiveD(D d) {
    dRef = d;
    dRef.f();
  }
}

interface E {
  interface G {
    void f();
  }
  // Sowo kluczowe "public" jest nadmiarowe:
  public interface H {
    void f();
  }
  void g();
  // Wewntrz interfejsu nie mona by prywatnym:
  //! private interface I {}
}

public class NestingInterfaces {
  public class BImp implements A.B {
    public void f() {}
  }
  class CImp implements A.C {
    public void f() {}
  }
  // Prywatnego interfejsu nie mona implementowa
  // nigdzie poza klas definijujc ten interfejs:
  //! class DImp implements A.D {
  //!  public void f() {}
  //! }
  class EImp implements E {
    public void g() {}
  }
  class EGImp implements E.G {
    public void f() {}
  }
  class EImp2 implements E {
    public void g() {}
    class EG implements E.G {
      public void f() {}
    }
  }
  public static void main(String[] args) {
    A a = new A();
    // Nie ma dostpu do A.D:
    //! A.D ad = a.getD();
    // Nie zwraca nic z wyjtkiem A.D:
    //! A.DImp2 di2 = a.getD();
    // Brak dostpu do skadowej interfejsu:
    //! a.getD().f();
    // Tylko inna instancja A moe co zrobi getD():
    A a2 = new A();
    a2.receiveD(a.getD());
  }
} ///:~
