//: c08:Month.java
// Solidniejszy system wylicze.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
package c08;
import com.bruceeckel.simpletest.*;

public final class Month {
  private static Test monitor = new Test();
  private String name;
  private Month(String nm) { name = nm; }
  public String toString() { return name; }
  public static final Month
    JAN = new Month("Stycze"),
    FEB = new Month("Luty"),
    MAR = new Month("Marzec"),
    APR = new Month("Kwiecie"),
    MAY = new Month("Maj"),
    JUN = new Month("Czerwiec"),
    JUL = new Month("Lipiec"),
    AUG = new Month("Sierpie"),
    SEP = new Month("Wrzesie"),
    OCT = new Month("Padziernik"),
    NOV = new Month("Listopad"),
    DEC = new Month("Grudzie");
  public static final Month[] month =  {
    JAN, FEB, MAR, APR, MAY, JUN,
    JUL, AUG, SEP, OCT, NOV, DEC
  };
  public static final Month number(int ord) {
    return month[ord - 1];
  }
  public static void main(String[] args) {
    Month m = Month.JAN;
    System.out.println(m);
    m = Month.number(12);
    System.out.println(m);
    System.out.println(m == Month.DEC);
    System.out.println(m.equals(Month.DEC));
    System.out.println(Month.month[3]);
    monitor.expect(new String[] {
      "Stycze",
      "Grudzie",
      "true",
      "true",
      "Kwiecie"
    });
  }
} ///:~
