//: c08:LocalInnerClass.java
// Przechowuje sekwencj obiektw Object.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

interface Counter {
  int next();
}

public class LocalInnerClass {
  private static Test monitor = new Test();
  private int count = 0;
  Counter getCounter(final String name) {
    // Lokalna klasa wewntrzna:
    class LocalCounter implements Counter {
      public LocalCounter() {
        // Lokalna klasa wewntrzna moe mie konstruktor
        System.out.println("LocalCounter()");
      }
      public int next() {
        System.out.print(name); // Dostp do lokalnej zmiennej sfinalizowanej
        return count++;
      }
    }
    return new LocalCounter();
  }
  
  // To samo rozwizanie wykorzystujce anonimow klas wewntrzn:
  Counter getCounter2(final String name) {
    return new Counter() {
      // Anonimowe klasy wewntrzne nie mog mie konstruktorw
      // a jedynie blok inicjalizacji instancji
      {
        System.out.println("Counter()");
      }
      public int next() {
        System.out.print(name); // Dostp do lokalnej zmiennej sfinalizowanej
        return count++;
      }
    };
  }
  public static void main(String[] args) {
    LocalInnerClass lic = new LocalInnerClass();
    Counter
      c1 = lic.getCounter("Lokalny obiekt wewntrzny "),
      c2 = lic.getCounter2("Anonimowy obiekt wewntrzny ");
    for(int i = 0; i < 5; i++)
      System.out.println(c1.next());
    for(int i = 0; i < 5; i++)
      System.out.println(c2.next());
    monitor.expect(new String[] {
      "LocalCounter()",
      "Counter()",
      "Lokalny obiekt wewntrzny 0",
      "Lokalny obiekt wewntrzny 1",
      "Lokalny obiekt wewntrzny 2",
      "Lokalny obiekt wewntrzny 3",
      "Lokalny obiekt wewntrzny 4",
      "Anonimowy obiekt wewntrzny 5",
      "Anonimowy obiekt wewntrzny 6",
      "Anonimowy obiekt wewntrzny 7",
      "Anonimowy obiekt wewntrzny 8",
      "Anonimowy obiekt wewntrzny 9"
    });
  }
} ///:~