//: c08:GreenhouseController.java
// Konfiguracja i uruchomienie systemu zarzdzania szklarni.
// {Argument: 5000}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import c08.controller.*;

public class GreenhouseController {
  public static void main(String[] args) {
    GreenhouseControls gc = new GreenhouseControls();
    // Informacje konfiguracyjne mona odczyta z pliku
    // a nie podawa na sta w kodzie programu.
    gc.addEvent(gc.new Bell(900));
    Event[] eventList = {
      gc.new ThermostatNight(0),
      gc.new LightOn(200),
      gc.new LightOff(400),
      gc.new WaterOn(600),
      gc.new WaterOff(800),
      gc.new ThermostatDay(1400)
    };
    gc.addEvent(gc.new Restart(2000, eventList));
    if(args.length == 1)
      gc.addEvent(
        gc.new Terminate(Integer.parseInt(args[0])));
    gc.run();
  }
} ///:~
