//: c07:PolyConstructors.java
// Konstruktory a polimorfizm
// rezultat inny ni mona przypuszcza.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

abstract class Glyph {
  abstract void draw();
  Glyph() {
    System.out.println("Glyph() przed draw()");
    draw();
    System.out.println("Glyph() po draw()");
  }
}

class RoundGlyph extends Glyph {
  private int radius = 1;
  RoundGlyph(int r) {
    radius = r;
    System.out.println(
      "RoundGlyph.RoundGlyph(), radius = " + radius);
  }
  void draw() {
    System.out.println(
      "RoundGlyph.draw(), radius = " + radius);
  }
}

public class PolyConstructors {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    new RoundGlyph(5);
    monitor.expect(new String[] {
      "Glyph() przed draw()",
      "RoundGlyph.draw(), radius = 0",
      "Glyph() po draw()",
      "RoundGlyph.RoundGlyph(), radius = 5"
    });
  }
} ///:~