//: c06:Bath.java
// Inicjalizacja wewntrz konstruktora w przypadku kompozycji.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Soap {
  private String s;
  Soap() {
    System.out.println("Soap()");
    s = new String("Skonstruowany");
  }
  public String toString() { return s; }
}

public class Bath {
  private static Test monitor = new Test();
  private String // Inicjalizacja w miejscu definicji:
    s1 = new String("Radosny"),
    s2 = "Radosny",
    s3, s4;
  private Soap castille;
  private int i;
  private float toy;
  public Bath() {
    System.out.println("Wewntrz Bath()");
    s3 = new String("Uradowany");
    i = 47;
    toy = 3.14f;
    castille = new Soap();
  }
  public String toString() {
    if(s4 == null) // Inicjalizacja opnkona
      s4 = new String("Uradowany");
    return
      "s1 = " + s1 + "\n" +
      "s2 = " + s2 + "\n" +
      "s3 = " + s3 + "\n" +
      "s4 = " + s4 + "\n" +
      "i = " + i + "\n" +
      "toy = " + toy + "\n" +
      "castille = " + castille;
  }
  public static void main(String[] args) {
    Bath b = new Bath();
    System.out.println(b);
    monitor.expect(new String[] {
      "Wewntrz Bath()",
      "Soap()",
      "s1 = Radosny",
      "s2 = Radosny",
      "s3 = Uradowany",
      "s4 = Uradowany",
      "i = 47",
      "toy = 3.14",
      "castille = Skonstruowany"
    });
  }
} ///:~
