//: c04:Overloading.java
// Przecienie konstruktora
// i zwykej metody.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.Test;
import java.util.*;

class Tree {
  int height;
  Tree() {
    System.out.println("Zasadzenie ziarna");
    height = 0;
  }
  Tree(int i) {
    System.out.println("Stworzenie nowego drzewa o wysokoci "
      + i + " metrw");
    height = i;
  }
  void info() {
    System.out.println("Wysoko drzewa to " + height + " metrw");
  }
  void info(String s) {
    System.out.println(s + ": Wysoko drzewa to "
      + height + " metrw");
  }
}

public class Overloading {
  static Test monitor = new Test();
  public static void main(String[] args) {
    for(int i = 0; i < 5; i++) {
      Tree t = new Tree(i);
      t.info();
      t.info("metoda przeciona");
    }
    // Konstruktor przeciony:
    new Tree();
    monitor.expect(new String[] {
      "Stworzenie nowego drzewa o wysokoci 0 metrw",
      "Wysoko drzewa to 0 metrw",
      "metoda przeciona: Wysoko drzewa to 0 metrw",
      "Stworzenie nowego drzewa o wysokoci 1 metrw",
      "Wysoko drzewa to 1 metrw",
      "metoda przeciona: Wysoko drzewa to 1 metrw",
      "Stworzenie nowego drzewa o wysokoci 2 metrw",
      "Wysoko drzewa to 2 metrw",
      "metoda przeciona: Wysoko drzewa to 2 metrw",
      "Stworzenie nowego drzewa o wysokoci 3 metrw",
      "Wysoko drzewa to 3 metrw",
      "metoda przeciona: Wysoko drzewa to 3 metrw",
      "Stworzenie nowego drzewa o wysokoci 4 metrw",
      "Wysoko drzewa to 4 metrw",
      "metoda przeciona: Wysoko drzewa to 4 metrw",
      "Zasadzenie ziarna"
    });
  }
} ///:~
