//: c04:OrderOfInitialization.java
// Demonstracja kolejnoci inicjalizacji.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

// Kiedy zostanie wywoywany konstruktor, aby stworzy
// obiekt Tag, pojawi si komunikat:
class Tag {
  Tag(int marker) {
    System.out.println("Tag(" + marker + ")");
  }
}

class Card {
  Tag t1 = new Tag(1); // Przed konstruktorem
  Card() {
    // Sygnalizacja, i jestemy w konstruktorze:
    System.out.println("Card()");
    t3 = new Tag(33); // Ponowna inicjalizacja t3
  }
  Tag t2 = new Tag(2); // Po konstruktorze
  void f() {
    System.out.println("f()");
  }
  Tag t3 = new Tag(3); // Na kocu
}

public class OrderOfInitialization {
  static Test monitor = new Test();
  public static void main(String[] args) {
    Card t = new Card();
    t.f(); // Pokazuje, i konstrukcja zostaa zakoczona
    monitor.expect(new String[] {
      "Tag(1)",
      "Tag(2)",
      "Tag(3)",
      "Card()",
      "Tag(33)",
      "f()"
    });
  }
} ///:~
