//: appendixa:CheckCloneable.java
// Sprawdzenie czy referencje mog by klonowane.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

// Nie mona tego sklonowa, poniewa nie przesania metody 
// clone():
class Ordinary {}

// Przesonicie clone(), ale brak implementacji
// Cloneable:
class WrongClone extends Ordinary {
  public Object clone() throws CloneNotSupportedException {
    return super.clone(); // zgasza wyjtek
  }
}

// Wykonuje wszystkie waciwe dla klonowania dziaania:
class IsCloneable extends Ordinary implements Cloneable {
  public Object clone() throws CloneNotSupportedException {
    return super.clone();
  }
}

// Wyczenie klonowania poprzez zgoszenie wyjtku:
class NoMore extends IsCloneable {
  public Object clone() throws CloneNotSupportedException {
    throw new CloneNotSupportedException();
  }
}

class TryMore extends NoMore {
  public Object clone() throws CloneNotSupportedException {
    // Wywoanie NoMore.clone() powoduje wyjtek:
    return super.clone();
  }
}

class BackOn extends NoMore {
  private BackOn duplicate(BackOn b) {
    // Jako zrobi a kopi b
    // i zwrci t kopi. Jest to kopia 
    // atrapa, tylko aby zobaczy:
    return new BackOn();
  }
  public Object clone() {
    // Nie wywouje NoMore.clone():
    return duplicate(this);
  }
}

// Nie mona z tego dziedziczy, a wic nie mona
// przesoni metody clone() tak jak w BackOn:
final class ReallyNoMore extends NoMore {}

public class CheckCloneable {
  private static Test monitor = new Test();
  public static Ordinary tryToClone(Ordinary ord) {
    String id = ord.getClass().getName();
    System.out.println("Prba " + id);
    Ordinary x = null;
    if(ord instanceof Cloneable) {
      try {
        x = (Ordinary)((IsCloneable)ord).clone();
        System.out.println("Sklonowano " + id);
      } catch(CloneNotSupportedException e) {
        System.err.println("Nie mona sklonowa " + id);
      }
    } else {
      System.out.println("Nie zaimplementowano interfejsu Cloneable");
    }
    return x;
  }
  public static void main(String[] args) {
    // Rzutowanie w gr:
    Ordinary[] ord = {
      new IsCloneable(),
      new WrongClone(),
      new NoMore(),
      new TryMore(),
      new BackOn(),
      new ReallyNoMore(),
    };
    Ordinary x = new Ordinary();
    // Tego wiersza nie mona skompilowa; 
    // metoda clone() klasy Object jest chroniona:
    //! x = (Ordinary)x.clone();
    // W pierwszej kolejnoci sprawdzamy czy klasa 
    // implementuje interfejs Cloneable:
    for(int i = 0; i < ord.length; i++)
      tryToClone(ord[i]);
    monitor.expect(new String[] {
      "Prba IsCloneable",
      "Sklonowano IsCloneable",
      "Prba WrongClone",
      "Nie zaimplementowano interfejsu Cloneable",
      "Prba NoMore",
      "Nie mona sklonowa NoMore",
      "Prba TryMore",
      "Nie mona sklonowa TryMore",
      "Prba BackOn",
      "Sklonowano BackOn",
      "Prba ReallyNoMore",
      "Nie mona sklonowa ReallyNoMore"
    });
  }
} ///:~
