//: c12:ViewBuffers.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.nio.*;
import com.bruceeckel.simpletest.*;

public class ViewBuffers {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    ByteBuffer bb = ByteBuffer.wrap(
      new byte[]{ 0, 0, 0, 0, 0, 0, 0, 'a' });
    bb.rewind();
    System.out.println("Bufor danych typu byte");
    while(bb.hasRemaining())
      System.out.println(bb.position()+ " -> " + bb.get());
    CharBuffer cb =
      ((ByteBuffer)bb.rewind()).asCharBuffer();
    System.out.println("Bufor danych typu char");
    while(cb.hasRemaining())
      System.out.println(cb.position()+ " -> " + cb.get());
    FloatBuffer fb =
      ((ByteBuffer)bb.rewind()).asFloatBuffer();
    System.out.println("Bufor danych typu float");
    while(fb.hasRemaining())
      System.out.println(fb.position()+ " -> " + fb.get());
    IntBuffer ib =
      ((ByteBuffer)bb.rewind()).asIntBuffer();
    System.out.println("Bufor danych typu int");
    while(ib.hasRemaining())
      System.out.println(ib.position()+ " -> " + ib.get());
    LongBuffer lb =
      ((ByteBuffer)bb.rewind()).asLongBuffer();
    System.out.println("Bufor danych typu long");
    while(lb.hasRemaining())
      System.out.println(lb.position()+ " -> " + lb.get());
    ShortBuffer sb =
      ((ByteBuffer)bb.rewind()).asShortBuffer();
    System.out.println("Bufor danych typu short");
    while(sb.hasRemaining())
      System.out.println(sb.position()+ " -> " + sb.get());
    DoubleBuffer db =
      ((ByteBuffer)bb.rewind()).asDoubleBuffer();
    System.out.println("Bufor danych typu double");
    while(db.hasRemaining())
      System.out.println(db.position()+ " -> " + db.get());
    monitor.expect(new String[] {
      "Bufor danych typu byte",
      "0 -> 0",
      "1 -> 0",
      "2 -> 0",
      "3 -> 0",
      "4 -> 0",
      "5 -> 0",
      "6 -> 0",
      "7 -> 97",
      "Bufor danych typu char",
      "0 -> \0",
      "1 -> \0",
      "2 -> \0",
      "3 -> a",
      "Bufor danych typu float",
      "0 -> 0.0",
      "1 -> 1.36E-43",
      "Bufor danych typu int",
      "0 -> 0",
      "1 -> 97",
      "Bufor danych typu long",
      "0 -> 97",
      "Bufor danych typu short",
      "0 -> 0",
      "1 -> 0",
      "2 -> 0",
      "3 -> 97",
      "Bufor danych typu double",
      "0 -> 4.8E-322"
    });
  }
} ///:~