//: c12:JGrep.java
// Bardzo prosta wersja programu "grep".
// {Argumenty wywoania: JGrep.java "\\b[Ssct]\\w+"}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.io.*;
import java.util.regex.*;
import java.util.*;
import com.bruceeckel.util.*;

public class JGrep {
  public static void main(String[] args) throws Exception {
    if(args.length < 2) {
      System.out.println("Sposb uycia: java JGrep plik wyraenieRegularne");
      System.exit(0);
    }
    Pattern p = Pattern.compile(args[1]);
    // Analizuje kolejne wiersze pliku wejciowego
    ListIterator it = new TextFile(args[0]).listIterator();
    while(it.hasNext()) {
      Matcher m = p.matcher((String)it.next());
      while(m.find())
        System.out.println(it.nextIndex() + ": " +
          m.group() + ": " + m.start());
    }
  }
} ///:~