//: c12:IOStreamDemo.java
// Typowe konfiguracje strumieni I/O.
// {Naley uruchamia rcznie}
// {Porzdki: IODemo.out,Data.txt,rtest.dat}
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;

public class IOStreamDemo {
  private static Test monitor = new Test();
  // Komunikaty o wyjtkach wypisujemy na konsol:
  public static void main(String[] args)
  throws IOException {
    // 1. Czytanie wejcia wierszami:
    BufferedReader in = new BufferedReader(
      new FileReader("IOStreamDemo.java"));
    String s, s2 = new String();
    while((s = in.readLine())!= null)
      s2 += s + "\n";
    in.close();
    // 1b. Czytanie ze standardowego wejcia:
    BufferedReader stdin = new BufferedReader(
      new InputStreamReader(System.in));
    System.out.print("Podaj lini tekstu:");
    System.out.println(stdin.readLine());

    // 2. Wejcie z pamici
    StringReader in2 = new StringReader(s2);
    int c;
    while((c = in2.read()) != -1)
      System.out.print((char)c);

    // 3. Formatowane wejcie z pamici
    try {
      DataInputStream in3 = new DataInputStream(
        new ByteArrayInputStream(s2.getBytes()));
      while(true)
        System.out.print((char)in3.readByte());
    } catch(EOFException e) {
      System.err.println("Koniec strumienia");
    }

    // 4. Wyjcie do pliku
    try {
      BufferedReader in4 = new BufferedReader(
        new StringReader(s2));
      PrintWriter out1 = new PrintWriter(
        new BufferedWriter(new FileWriter("IODemo.out")));
      int lineCount = 1;
      while((s = in4.readLine()) != null )
        out1.println(lineCount++ + ": " + s);
      out1.close();
    } catch(EOFException e) {
      System.err.println("Koniec strumienia");
    }

    // 5. Przechowywanie i odzyskiwanie danych
    try {
      DataOutputStream out2 = new DataOutputStream(
        new BufferedOutputStream(
          new FileOutputStream("Data.txt")));
      out2.writeDouble(3.14159);
      out2.writeUTF("To byo pi");
      out2.writeDouble(1.41413);
      out2.writeUTF("Pierwiastek kwadratowy z 2");
      out2.close();
      DataInputStream in5 = new DataInputStream(
        new BufferedInputStream(
          new FileInputStream("Data.txt")));
      // Dla danych trzeba uy DataInputStream:
      System.out.println(in5.readDouble());
      // Jedynie metoda readUTF() odzyska 
      // Java-UTF String prawidowo:
      System.out.println(in5.readUTF());
      // Odczyt kolejnej liczby double i Stringu:
      System.out.println(in5.readDouble());
      System.out.println(in5.readUTF());
    } catch(EOFException e) {
      throw new RuntimeException(e);
    }

    // 6. Odczyt/zapis do plikw o swobodnym dostpie
    RandomAccessFile rf =
      new RandomAccessFile("rtest.dat", "rw");
    for(int i = 0; i < 10; i++)
      rf.writeDouble(i*1.414);
    rf.close();
    rf = new RandomAccessFile("rtest.dat", "rw");
    rf.seek(5*8);
    rf.writeDouble(47.0001);
    rf.close();
    rf = new RandomAccessFile("rtest.dat", "r");
    for(int i = 0; i < 10; i++)
      System.out.println("Warto " + i + ": " +
        rf.readDouble());
    rf.close();
    monitor.expect("IOStreamDemo.out");
  }
} ///:~