//: c12:Groups.java
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.regex.*;
import com.bruceeckel.simpletest.*;

public class Groups {
  private static Test monitor = new Test();
  static public final String poem =
    "Brzdeniao ju; limonne prztowie\n" +
    "Wyro i waro si w gulbiey;\n" +
    "Zmimszae wiy borogowie\n" +
    "I rcie grdypay z mrzerzy.\n" +
    "O, strze si, synu, Dziaberlaka!\n" +
    "ap pazurzastych, zbnej paszczy!\n" +
    "Omi Dziupdziupa, zego ptaka,\n" +
    "Z ktrym si Brutrwiel piastrzy!\n";
  public static void main(String[] args) {
    Matcher m =
      Pattern.compile("(?m)(\\S+)\\s+((\\S+)\\s+(\\S+))$")
        .matcher(poem);
    while(m.find()) {
      for(int j = 0; j <= m.groupCount(); j++)
        System.out.print("[" + m.group(j) + "]");
      System.out.println();
    }
    monitor.expect(new String[]{
      "[ju; limonne prztowie][ju;][limonne prztowie]" + 
      "[limonne][prztowie]",
      "[si w gulbiey;][si][w gulbiey;][w][gulbiey;]",
      "[Zmimszae wiy borogowie][Zmimszae][wiy borogowie]" + 
      "[wiy][borogowie]",
      "[grdypay z mrzerzy.][grdypay][z mrzerzy.][z][mrzerzy.]",
      "[si, synu, Dziaberlaka!][si,][synu, Dziaberlaka!][synu,]" + 
      "[Dziaberlaka!]",
      "[pazurzastych, zbnej paszczy!][pazurzastych,]" + 
      "[zbnej paszczy!][zbnej][paszczy!]",
      "[Dziupdziupa, zego ptaka,][Dziupdziupa,][zego ptaka,]" + 
      "[zego][ptaka,]",
      "[si Brutrwiel piastrzy!][si][Brutrwiel piastrzy!]" + 
      "[Brutrwiel][piastrzy!]" });
  }
} ///:~