//: c11:SpringDetector.java
// Jaka bdzie pogoda?
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;
import java.lang.reflect.*;

public class SpringDetector {
  private static Test monitor = new Test();
  // Uywana jest klasa Groundhog lub jedna z jej klas potomnych:
  public static void
  detectSpring(Class groundHogClass) throws Exception {
    Constructor ghog = groundHogClass.getConstructor(
      new Class[] {int.class});
    Map map = new HashMap();
    for(int i = 0; i < 10; i++)
      map.put(ghog.newInstance(
        new Object[]{ new Integer(i) }), new Prediction());
    System.out.println("map = " + map + "\n");
    Groundhog gh = (Groundhog)
      ghog.newInstance(new Object[]{ new Integer(3) });
    System.out.println("Sprawdzenie prognozy dla: " + gh);
    if(map.containsKey(gh))
      System.out.println((Prediction)map.get(gh));
    else
      System.out.println("Nie znaleziono klucza: " + gh);
  }
  public static void main(String[] args) throws Exception {
    detectSpring(Groundhog.class);
    monitor.expect(new String[] {
      "%% map = \\{(wistak nr. \\d=" +
      "(Wczesna wiosna!|Dalsze sze miesicy zimy!)" +
      "(, )?){10}\\}",
      "",
      "Sprawdzenie prognozy dla: wistak nr. 3",
      "Nie znaleziono klucza: wistak nr. 3"
    });
    }
} ///:~
