//: c11:Set1.java
// To co mona zrobi z obiektami typu Set.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;

public class Set1 {
  private static Test monitor = new Test();
  static void fill(Set s) {
    s.addAll(Arrays.asList(
      "jeden dwa trzy cztery pi sze siedem".split(" ")));
  }
  public static void test(Set s) {
    // Usunicie kwalifikatorw z nazwy klasy
    System.out.println(
      s.getClass().getName().replaceAll("\\w+\\.", ""));
    fill(s); fill(s); fill(s);
    System.out.println(s); // Bez powtarzajcych si elementw
    // Dodajemy kolejny zbir do ju istniejcego:
    s.addAll(s);
    s.add("jeden");
    s.add("jeden");
    s.add("jeden");
    System.out.println(s);
    // Odszukanie czego:
    System.out.println("s.contains(\"jeden\"): " +
      s.contains("jeden"));
  }
  public static void main(String[] args) {
    test(new HashSet());
    test(new TreeSet());
    test(new LinkedHashSet());
    monitor.expect(new String[] {
      "HashSet",
      "[jeden, trzy, cztery, dwa, siedem, sze, pi]",
      "[jeden, trzy, cztery, dwa, siedem, sze, pi]",
      "s.contains(\"jeden\"): true",
      "TreeSet",
      "[cztery, dwa, jeden, pi, siedem, sze, trzy]",
      "[cztery, dwa, jeden, pi, siedem, sze, trzy]",
      "s.contains(\"jeden\"): true",
      "LinkedHashSet",
      "[jeden, dwa, trzy, cztery, pi, sze, siedem]",
      "[jeden, dwa, trzy, cztery, pi, sze, siedem]",
      "s.contains(\"jeden\"): true"
    });
  }
} ///:~
