//: c11:Map1.java
// To, co mona zrobi z odwzorowaniami Map.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;
import com.bruceeckel.util.*;

public class Map1 {
  private static Collections2.StringPairGenerator geo =
    Collections2.geography;
  private static Collections2.RandStringPairGenerator
    rsp = Collections2.rsp;
  // Przedstawienie zbioru (Set) kluczy:
  public static void printKeys(Map map) {
    System.out.print("Rozmiar = " + map.size() + ", ");
    System.out.print("Klucze: ");
    System.out.println(map.keySet());
  }
  public static void test(Map map) {
    // Usunicie kwalifikatorw z nazwy klasy:
    System.out.println(
      map.getClass().getName().replaceAll("\\w+\\.", ""));
    Collections2.fill(map, geo, 25);
    // Odwzorowanie Map wobec kluczy zachowuje si jak 'Set':
    Collections2.fill(map, geo.reset(), 25);
    printKeys(map);
    // Stworzenie kolekcji (Collection) wartoci:
    System.out.print("Wartoci: ");
    System.out.println(map.values());
    System.out.println(map);
    String key = CountryCapitals.pairs[4][0];
    String value = CountryCapitals.pairs[4][1];
    System.out.println("map.containsKey(\"" + key +
      "\"): " + map.containsKey(key));
    System.out.println("map.get(\"" + key + "\"): "
      + map.get(key));
    System.out.println("map.containsValue(\""
      + value + "\"): " + map.containsValue(value));
    Map map2 = new TreeMap();
    Collections2.fill(map2, rsp, 25);
    map.putAll(map2);
    printKeys(map);
    key = map.keySet().iterator().next().toString();
    System.out.println("Pierwszy klucz w odwzorowaniu: " + key);
    map.remove(key);
    printKeys(map);
    map.clear();
    System.out.println("map.isEmpty(): " + map.isEmpty());
    Collections2.fill(map, geo.reset(), 25);
    // Operacje na zbiorze kluczy zmieniaj te odwzorowanie:
    map.keySet().removeAll(map.keySet());
    System.out.println("map.isEmpty(): " + map.isEmpty());
  }
  public static void main(String[] args) {
    test(new HashMap());
    test(new TreeMap());
    test(new LinkedHashMap());
    test(new IdentityHashMap());
    test(new WeakHashMap());
  }
} ///:~
