//: c11:List1.java
// Co mona zrobi z Listami.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import java.util.*;
import com.bruceeckel.util.*;

public class List1 {
  public static List fill(List a) {
    Collections2.countries.reset();
    Collections2.fill(a, Collections2.countries, 10);
    return a;
  }
  private static boolean b;
  private static Object o;
  private static int i;
  private static Iterator it;
  private static ListIterator lit;
  public static void basicTest(List a) {
    a.add(1, "x"); // Dodanie elementu na pozycj 1
    a.add("x"); // Dodanie na koniec
    // Dodanie kolekcji:
    a.addAll(fill(new ArrayList()));
    // Dodanie kolekcji poczynajc od pozycji 3:
    a.addAll(3, fill(new ArrayList()));
    b = a.contains("1"); // Czy tam jest?
    // Czy caa kolekcja tam jest?
    b = a.containsAll(fill(new ArrayList()));
    // List pozwala na swobodny dostp, ktry jest tani
    // w przypadku ArrayList i kosztowny w przypadku LinkedList:
    o = a.get(1); // Podaj obiekt z pozycji 1
    i = a.indexOf("1"); // Podaj indeks obiektu
    b = a.isEmpty(); // Jest tam co?
    it = a.iterator(); // Zwyky Iterator
    lit = a.listIterator(); // ListIterator
    lit = a.listIterator(3); // Zacznij od pozycji 3
    i = a.lastIndexOf("1"); // Ostatni pasujcy 
    a.remove(1); // Usu pozycj 1
    a.remove("3"); // Usu ten obiekt
    a.set(1, "y"); // Ustaw pozycj 1 na "y"
    // Zatrzymaj wszystko, co jest w argumencie
    // (przecicie dwch zbiorw):
    a.retainAll(fill(new ArrayList()));
    // Usu wszystko, co jest w argumencie:
    a.removeAll(fill(new ArrayList()));
    i = a.size(); // Jakie to jest due?
    a.clear(); // Usu wszystkie elementy
  }
  public static void iterMotion(List a) {
    ListIterator it = a.listIterator();
    b = it.hasNext();
    b = it.hasPrevious();
    o = it.next();
    i = it.nextIndex();
    o = it.previous();
    i = it.previousIndex();
  }
  public static void iterManipulation(List a) {
    ListIterator it = a.listIterator();
    it.add("47");
    // Po add() koniecznie ustaw si na elemencie:
    it.next();
    // Usu wanie uzyskany element:
    it.remove();
    // Po remove() koniecznie ustaw si na jakim elemencie:
    it.next();
    // Zmie wanie uzyskany element:
    it.set("47");
  }
  public static void testVisual(List a) {
    System.out.println(a);
    List b = new ArrayList();
    fill(b);
    System.out.print("b = ");
    System.out.println(b);
    a.addAll(b);
    a.addAll(fill(new ArrayList()));
    System.out.println(a);
    // Wstaw, usu i podmie elementy
    // stosujc ListIterator:
    ListIterator x = a.listIterator(a.size()/2);
    x.add("jeden");
    System.out.println(a);
    System.out.println(x.next());
    x.remove();
    System.out.println(x.next());
    x.set("47");
    System.out.println(a);
    // Przejd list od tyu:
    x = a.listIterator(a.size());
    while(x.hasPrevious())
      System.out.print(x.previous() + " ");
    System.out.println();
    System.out.println("testVisual zakoczona");
  }
  // Jest kilka rzeczy, ktre mog obsuy
  // tylko listy klasy LinkedList:
  public static void testLinkedList() {
    LinkedList ll = new LinkedList();
    fill(ll);
    System.out.println(ll);
    // Potraktuj list jak stos, woenie elementu - push:
    ll.addFirst("jeden");
    ll.addFirst("dwa");
    System.out.println(ll);
    // Jak "zerknicie" na szczyt stosu - top:
    System.out.println(ll.getFirst());
    // Jak zdjcie elementu ze szczytu - pop:
    System.out.println(ll.removeFirst());
    System.out.println(ll.removeFirst());
    // Potraktowanie listy jak kolejki, pobranie elementu    
    // z koca kolejki:
    System.out.println(ll.removeLast());
    // Razem z powyszymi operacjami mamy kolejk dwukierunkow!
    System.out.println(ll);
  }
  public static void main(String[] args) {
    // Stwrz i wypenij now list za kadym razem:
    basicTest(fill(new LinkedList()));
    basicTest(fill(new ArrayList()));
    iterMotion(fill(new LinkedList()));
    iterMotion(fill(new ArrayList()));
    iterManipulation(fill(new LinkedList()));
    iterManipulation(fill(new ArrayList()));
    testVisual(fill(new LinkedList()));
    testLinkedList();
  }
} ///:~
