//: c08:Parcel9.java
// Wykorzystanie "inicjalizacji instancji" do
// przeprowadzenia konstrukcji 
// anonimowej klasy wewntrznej.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

public class Parcel9 {
  private static Test monitor = new Test();
  public Destination
  dest(final String dest, final float price) {
    return new Destination() {
      private int cost;
      // Inicjalizacja instancji dla kadego obiektu:
      {
        cost = Math.round(price);
        if(cost > 100)
          System.out.println("Budet przekroczony!");
      }
      private String label = dest;
      public String readLabel() { return label; }
    };
  }
  public static void main(String[] args) {
    Parcel9 p = new Parcel9();
    Destination d = p.dest("Tanzania", 101.395F);
    monitor.expect(new String[] {
      "Budet przekroczony!"
    });
  }
} ///:~
