//: c08:GreenhouseControls.java
// Zawarcie konkretnej aplikacji sterujcej w jednej klasie.
// Klasy wewntrzne pozwalaj na hermetyzacj 
// odmiennych funkcji kadego ze zdarze.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import c08.controller.*;

public class GreenhouseControls extends Controller {
  private static Test monitor = new Test();
  private boolean light = false;
  public class LightOn extends Event {
    public LightOn(long delayTime) { super(delayTime); }
    public void action() {
      // Tu naley umieci kod kontroli sprztu
      // w celu fizycznego wczenia wiata.
      light = true;
    }
    public String toString() { return "wiato zapalone"; }
  }
  public class LightOff extends Event {
    public LightOff(long delayTime) { super(delayTime); }
    public void action() {
      // Tu naley umieci kod kontroli sprztu
      // w celu fizycznego wyczenia wiata.
      light = false;
    }
    public String toString() { return "wiato zgaszone"; }
  }
  private boolean water = false;
  public class WaterOn extends Event {
    public WaterOn(long delayTime) { super(delayTime); }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      water = true;
    }
    public String toString() {
      return "Woda w szklarni wczona";
    }
  }
  public class WaterOff extends Event {
    public WaterOff(long delayTime) { super(delayTime); }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      water = false;
    }
    public String toString() {
      return "Woda w szklarni wyczona";
    }
  }
  private String thermostat = "Dzie";
  public class ThermostatNight extends Event {
    public ThermostatNight(long delayTime) {
      super(delayTime);
    }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      thermostat = "Noc";
    }
    public String toString() {
      return "Termostat przeszed na ustawienia nocne";
    }
  }
  public class ThermostatDay extends Event {
    public ThermostatDay(long delayTime) {
      super(delayTime);
    }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      thermostat = "Dzie";
    }
    public String toString() {
      return "Termostat przeszed na ustawienia dzienn";
    }
  }
  // Przykad akcji wstawiajcej nowy egzemplarz swojego 
  // zdarzenia do listy zdarze:
  public class Bell extends Event {
    public Bell(long delayTime) { super(delayTime); }
    public void action() {
      addEvent(new Bell(delayTime));
    }
    public String toString() { return "Dzyn!"; }
  }
  public class Restart extends Event {
    private Event[] eventList;
    public Restart(long delayTime, Event[] eventList) {
      super(delayTime);
      this.eventList = eventList;
      for(int i = 0; i < eventList.length; i++)
        addEvent(eventList[i]);
    }
    public void action() {
      for(int i = 0; i < eventList.length; i++) {
        eventList[i].start(); // Zwr poszczeglne zdarzenia
        addEvent(eventList[i]);
      }
      start(); // Zwr to zdarzenie
      addEvent(this);
    }
    public String toString() {
      return "Ponowne uruchomienie systemu";
    }
  }
  public class Terminate extends Event {
    public Terminate(long delayTime) { super(delayTime); }
    public void action() { System.exit(0); }
    public String toString() { return "Zakaczanie pracy";  }
  }
} ///:~
