//: c08:AnonymousConstructor.java
// Tworzenie konstruktora anonimowej klasy wewntrznej.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

abstract class Base {
  public Base(int i) {
    System.out.println("Konstruktor klasy Base, i = " + i);
  }
  public abstract void f();
}

public class AnonymousConstructor {
  private static Test monitor = new Test();
  public static Base getBase(int i) {
    return new Base(i) {
      {
        System.out.println("Wewntrz inicjalizacji instancji");
      }
      public void f() {
        System.out.println("W anonimowej metodzie f()");
      }
    };
  }
  public static void main(String[] args) {
    Base base = getBase(47);
    base.f();
    monitor.expect(new String[] {
      "Konstruktor klasy Base, i = 47",
      "Wewntrz inicjalizacji instancji",
      "W anonimowej metodzie f()"
    });
  }
} ///:~