//: c06:CADSystem.java
// Zapewnienie waciwego sprztania.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
package c06;
import com.bruceeckel.simpletest.*;
import java.util.*;

class Shape {
  Shape(int i) {
    System.out.println("Konstruktor ksztatu");
  }
  void dispose() {
    System.out.println("Sprztanie ksztatu");
  }
}

class Circle extends Shape {
  Circle(int i) {
    super(i);
    System.out.println("Rysowanie koa");
  }
  void dispose() {
    System.out.println("Wymazanie koa");
    super.dispose();
  }
}

class Triangle extends Shape {
  Triangle(int i) {
    super(i);
    System.out.println("Rysowanie trjkta");
  }
  void dispose() {
    System.out.println("Wymazanie trjkta");
    super.dispose();
  }
}

class Line extends Shape {
  private int start, end;
  Line(int start, int end) {
    super(start);
    this.start = start;
    this.end = end;
    System.out.println("Rysowanie linii: "+ start+ ", "+ end);
  }
  void dispose() {
    System.out.println("Wymazanie linii: "+ start+ ", "+ end);
    super.dispose();
  }
}

public class CADSystem extends Shape {
  private static Test monitor = new Test();
  private Circle c;
  private Triangle t;
  private Line[] lines = new Line[5];
  public CADSystem(int i) {
    super(i + 1);
    for(int j = 0; j < lines.length; j++)
      lines[j] = new Line(j, j*j);
    c = new Circle(1);
    t = new Triangle(1);
    System.out.println("Konstruktor systemu");
  }
  public void dispose() {
    System.out.println("CADSystem.dispose()");
    // Kolejno czyszczenia jest odwrotna
    // w stosunku do kolejnoci inicjalizacji
    t.dispose();
    c.dispose();
    for(int i = lines.length - 1; i >= 0; i--)
      lines[i].dispose();
    super.dispose();
  }
  public static void main(String[] args) {
    CADSystem x = new CADSystem(47);
    try {
      // Kod i obsuga wyjtkw ...
    } finally {
      x.dispose();
    }
    monitor.expect(new String[] {
      "Konstruktor ksztatu",
      "Konstruktor ksztatu",
      "Rysowanie linii: 0, 0",
      "Konstruktor ksztatu",
      "Rysowanie linii: 1, 1",
      "Konstruktor ksztatu",
      "Rysowanie linii: 2, 4",
      "Konstruktor ksztatu",
      "Rysowanie linii: 3, 9",
      "Konstruktor ksztatu",
      "Rysowanie linii: 4, 16",
      "Konstruktor ksztatu",
      "Rysowanie koa",
      "Konstruktor ksztatu",
      "Rysowanie trjkta",
      "Konstruktor systemu",
      "CADSystem.dispose()",
      "Wymazanie trjkta",
      "Sprztanie ksztatu",
      "Wymazanie koa",
      "Sprztanie ksztatu",
      "Wymazanie linii: 4, 16",
      "Sprztanie ksztatu",
      "Wymazanie linii: 3, 9",
      "Sprztanie ksztatu",
      "Wymazanie linii: 2, 4",
      "Sprztanie ksztatu",
      "Wymazanie linii: 1, 1",
      "Sprztanie ksztatu",
      "Wymazanie linii: 0, 0",
      "Sprztanie ksztatu",
      "Sprztanie ksztatu"
    });
  }
} ///:~
