//: c04:TerminationCondition.java
// Wykorzystanie finalize() do wykrycia obiektu, 
// ktry nie zosta waciwie zniszczony.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class Book {
  boolean checkedOut = false;
  Book(boolean checkOut) {
    checkedOut = checkOut;
  }
  void checkIn() {
    checkedOut = false;
  }
  public void finalize() {
    if(checkedOut)
      System.out.println("Bd: nadal checkedOut");
  }
}

public class TerminationCondition {
  static Test monitor = new Test();
  public static void main(String[] args) {
    Book novel = new Book(true);
    // Waciwe sprztanie:
    novel.checkIn();
    // Zgubienie referencji i zapomnienie o sprztaniu:
    new Book(true);
    // Wymuszenie odmiecania pamici i finalizacji:
    System.gc();
    monitor.expect(new String[] {
      "Bd: nadal checkedOut"}, Test.WAIT);
  }
} ///:~
