//: appendixa:CopyConstructor.java
// Konstruktor do kopiowania obiektu tego samego
// typu, jako prba stworzenia kopii lokalnej.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.lang.reflect.*;

class FruitQualities {
  private int weight;
  private int color;
  private int firmness;
  private int ripeness;
  private int smell;
  // i tak dalej...
  public FruitQualities() { // Konstruktor domylny
    // zrb cos sensownego...
  }
  // Inne konstruktory:
  // ...
  // Konstruktor kopiujcy:
  public FruitQualities(FruitQualities f) {
    weight = f.weight;
    color = f.color;
    firmness = f.firmness;
    ripeness = f.ripeness;
    smell = f.smell;
    // itd.
  }
}

class Seed {
  // Skadowe...
  public Seed() { /* Konstruktor domylny */ }
  public Seed(Seed s) { /* Konstruktor kopiujcy */ }
}

class Fruit {
  private FruitQualities fq;
  private int seeds;
  private Seed[] s;
  public Fruit(FruitQualities q, int seedCount) {
    fq = q;
    seeds = seedCount;
    s = new Seed[seeds];
    for(int i = 0; i < seeds; i++)
      s[i] = new Seed();
  }
  // Inne konstruktory:
  // ...
  // Konstruktor kopiujcy:
  public Fruit(Fruit f) {
    fq = new FruitQualities(f.fq);
    seeds = f.seeds;
    s = new Seed[seeds];
    // Wywoaj konstruktory kopiujce wszystkich Seed:
    for(int i = 0; i < seeds; i++)
      s[i] = new Seed(f.s[i]);
    // Inne dziaania konstrukcji kopiujcej...
  }
  // Aby pozwoli konstruktorom pochodnym (lub innym
  // metodom) na okrelenie rnych waciwoci:
  protected void addQualities(FruitQualities q) {
    fq = q;
  }
  protected FruitQualities getQualities() {
    return fq;
  }
}

class Tomato extends Fruit {
  public Tomato() {
    super(new FruitQualities(), 100);
  }
  public Tomato(Tomato t) { // Konstruktor kopiujcy
    super(t); // Przekazanie w gr do konstruktora kopiujcego
    // Pozostae dziaania konstrukcji kopiujcej...
  }
}

class ZebraQualities extends FruitQualities {
  private int stripedness;
  public ZebraQualities() { // Konstruktor domylny
    super();
    // zrb cos sensownego...
  }
  public ZebraQualities(ZebraQualities z) {
    super(z);
    stripedness = z.stripedness;
  }
}

class GreenZebra extends Tomato {
  public GreenZebra() {
    addQualities(new ZebraQualities());
  }
  public GreenZebra(GreenZebra g) {
    super(g); // Wywoaj Tomato(Tomato)
    // Przywr poprawne waciwoci:
    addQualities(new ZebraQualities());
  }
  public void evaluate() {
    ZebraQualities zq = (ZebraQualities)getQualities();
    // Zrb co z tymi waciwociami
    // ...
  }
}

public class CopyConstructor {
  private static Test monitor = new Test();
  public static void ripen(Tomato t) {
    // Uyj "konstruktora kopiujcego":
    t = new Tomato(t);
    System.out.println("W ripen, t jest " +
      t.getClass().getName());
  }
  public static void slice(Fruit f) {
    f = new Fruit(f); // Hmmm... czy to zadziaa?
    System.out.println("W slice, f jest " +
      f.getClass().getName());
  }
  public static void ripen2(Tomato t) {
    try {
      Class c = t.getClass();
    // Uyj "konstruktora kopiujcego":
      Constructor ct = c.getConstructor(new Class[] { c });
      Object obj = ct.newInstance(new Object[] { t });
      System.out.println("W ripen2, t jest " +
        obj.getClass().getName());
    }
    catch(Exception e) { System.out.println(e); }
  }
  public static void slice2(Fruit f) {
    try {
      Class c = f.getClass();
      Constructor ct = c.getConstructor(new Class[] { c });
      Object obj = ct.newInstance(new Object[] { f });
      System.out.println("W slice2, f jest " +
        obj.getClass().getName());
    }
    catch(Exception e) { System.out.println(e); }
  }
  public static void main(String[] args) {
    Tomato tomato = new Tomato();
    ripen(tomato); // OK
    slice(tomato); // UPS!
    ripen2(tomato); // OK
    slice2(tomato); // OK
    GreenZebra g = new GreenZebra();
    ripen(g); // UPS!
    slice(g); // UPS!
    ripen2(g); // OK
    slice2(g); // OK
    g.evaluate();
    monitor.expect(new String[] {
      "W ripen, t jest Tomato",
      "W slice, f jest Fruit",
      "W ripen2, t jest Tomato",
      "W slice2, f jest Tomato",
      "W ripen, t jest Tomato",
      "W slice, f jest Fruit",
      "W ripen2, t jest GreenZebra",
      "W slice2, f jest GreenZebra"
    });
  }
} ///:~