
//: C10:InnerClassIdiom.cpp
// Przykad implementacji klasy wewntrznej
#include <iostream>
#include <string>
using namespace std;

class Poingable {
public:
  virtual void poing() = 0;
};

void callPoing(Poingable& p) {
  p.poing();
}

class Bingable {
public:
  virtual void bing() = 0;
};

void callBing(Bingable& b) {
  b.bing();
}

class Outer {
  string name;
  // Definicja jednej klasy wewntrznej:
  class Inner1;
  friend class Outer::Inner1;
  class Inner1 : public Poingable {
    Outer* parent;
  public:
    Inner1(Outer* p) : parent(p) {}
    void poing() {
      cout << "wywoanie poing dla "
        << parent->name << endl;
      // Dostp do skadowych danych klasy zawierajcej
    }
  } inner1;
  // Definicja drugiej klasy wewntrznej:
  class Inner2;
  friend class Outer::Inner2;
  class Inner2 : public Bingable {
    Outer* parent;
  public:
    Inner2(Outer* p) : parent(p) {}
    void bing() {
      cout << "wywoanie bing dla "
        << parent->name << endl;
    }
  } inner2;
public:
  Outer(const string& nm)
  : name(nm), inner1(this), inner2(this) {}
  // Zwrcenie referencji do interfejsw
  // implementowanych przez klasy wewntrzne:
  operator Poingable&() { return inner1; }
  operator Bingable&() { return inner2; }
};

int main() {
  Outer x("Ping Pong");
  // Podobiestwo do rzutowania w gr na wiele typw bazowych!:
  callPoing(x);
  callBing(x);
} ///:~
