
//: C06:CalcInventory.cpp
// Dalsze przykady zastosowania for_each()
#include "Inventory.h"
#include "PrintSequence.h"
#include <vector>
#include <algorithm>
#include <ctime>
using namespace std;

// Do obliczenia sum stanw magazynowych:
class InvAccum {
  int quantity;
  int value;
public:
  InvAccum() : quantity(0), value(0) {}
  void operator()(const Inventory& inv) {
    quantity += inv.getQuantity();
    value += inv.getQuantity() * inv.getValue();
  }
  friend ostream&
  operator<<(ostream& os, const InvAccum& ia) {
    return os << "czna ilo: "
      << ia.quantity
      << ", czna warto: " << ia.value;
  }
};

int main() {
  vector<Inventory> vi;
  srand(time(0));  //Losowo
  generate_n(back_inserter(vi), 15, InvenGen());
  print(vi.begin(), vi.end(), "vi");
  InvAccum ia = for_each(vi.begin(), vi.end(),
    InvAccum());
  cout << ia << endl;
} ///:~
