
//: C04:Effector.cpp
// Efektory Jerry'ego Schwarza
#include <cassert>
#include <limits>  // z uwagi na max()
#include <sstream>
#include <string>
using namespace std;

// Poka przedrostek acucha
class Fixw {
  string str;
public:
  Fixw(const string& s, int width)
    : str(s, 0, width) {}
  friend ostream&
  operator<<(ostream& os, const Fixw& fw) {
    return os << fw.str;
  }
};

// Poka liczb w formie binarnej
typedef unsigned long ulong;
class Bin {
  ulong n;
public:
  Bin(ulong nn) { n = nn; }
  friend ostream& operator<<(ostream& os, const Bin& b) {
    const ulong ULMAX = numeric_limits<ulong>::max();
    ulong bit = ~(ULMAX >> 1); // Ustawiony pierwszy bit
    while(bit) {
      os << (b.n & bit ? '1' : '0');
      bit >>= 1;
    }
    return os;
  }
};

int main() {
  string words =
    "Rzeczy dajce nam szczcie daj nam mdro";
  for(int i = words.size(); --i >= 0;) {
    ostringstream s;
    s << Fixw(words, i);
    assert(s.str() == words.substr(0, i));
  }
  ostringstream xs, ys;
  xs << Bin(0xCAFEBABEUL);
  assert(xs.str() ==
    "1100""1010""1111""1110""1011""1010""1011""1110");
  ys << Bin(0x76543210UL);
  assert(ys.str() ==
    "0111""0110""0101""0100""0011""0010""0001""0000");
} ///:~
