
//: C11:ToastOMaticMarkII.cpp {RunByHand}
// Rozwizanie problemu prawidowego tostowania z wykorzystaniem kolejek TQueue
//{L} ZThread
#include <iostream>
#include <string>
#include <cstdlib>
#include <ctime>
#include "zthread/Thread.h"
#include "zthread/Mutex.h"
#include "zthread/Guard.h"
#include "zthread/Condition.h"
#include "zthread/ThreadedExecutor.h"
#include "TQueue.h"
using namespace ZThread;
using namespace std;

class Toast {
  enum Status { DRY, BUTTERED, JAMMED };
  Status status;
  int id;
public:
  Toast(int idn) : status(DRY), id(idn) {}
  #ifdef __DMC__ // Niepoprawne wymaganie wartoci domylnych
  Toast() { assert(0); } // Nie powinno by wywoywane
  #endif
  void butter() { status = BUTTERED; }
  void jam() { status = JAMMED; }
  string getStatus() const {
    switch(status) {
      case DRY: return "suchy";
      case BUTTERED: return "z masem";
      case JAMMED: return "z demem";
      default: return "bd";
    }
  }
  int getId() { return id; }
  friend ostream& operator<<(ostream& os, const Toast& t) {
    return os << "Tost " << t.id << ": " << t.getStatus();
  }
};

typedef CountedPtr< TQueue<Toast> > ToastQueue;

class Toaster : public Runnable {
  ToastQueue toastQueue;
  int count;
public:
  Toaster(ToastQueue& tq) : toastQueue(tq), count(0) {}
  void run() {
    try {
      while(!Thread::interrupted()) {
        int delay = rand()/(RAND_MAX/5)*100;
        Thread::sleep(delay);
        // Opiekanie tostu
        Toast t(count++);
        cout << t << endl;
        // Wstawienie tostu do kolejki
        toastQueue->put(t);
      }
    } catch(Interrupted_Exception&) { /* Wyjcie */ }
    cout << "Toster wyczony" << endl;
  }
};

// Smarowanie tostu masem:
class Butterer : public Runnable {
  ToastQueue dryQueue, butteredQueue;
public:
  Butterer(ToastQueue& dry, ToastQueue& buttered)
  : dryQueue(dry), butteredQueue(buttered) {}
  void run() {
    try {
      while(!Thread::interrupted()) {
        // Blokowanie do momentu dostpnoci nastpnego tostu:
        Toast t = dryQueue->get();
        t.butter();
        cout << t << endl;
        butteredQueue->put(t);
      }
    } catch(Interrupted_Exception&) { /* Wyjcie */ }
    cout << "Modu smarowania masem wyczony" << endl;
  }
};

// Smarowanie tostu demem:
class Jammer : public Runnable {
  ToastQueue butteredQueue, finishedQueue;
public:
  Jammer(ToastQueue& buttered, ToastQueue& finished)
  : butteredQueue(buttered), finishedQueue(finished) {}
  void run() {
    try {
      while(!Thread::interrupted()) {
        // Blokowanie do momentu pojawienia si w kolejce tostu z masem:
        Toast t = butteredQueue->get();
        t.jam();
        cout << t << endl;
        finishedQueue->put(t);
      }
    } catch(Interrupted_Exception&) { /* Wyjcie */ }
    cout << "Modu smarowania demem wyczony" << endl;
  }
};

// Konsument tostw:
class Eater : public Runnable {
  ToastQueue finishedQueue;
  int counter;
public:
  Eater(ToastQueue& finished)
  : finishedQueue(finished), counter(0) {}
  void run() {
    try {
      while(!Thread::interrupted()) {
        // Blokowanie do momentu pojawienia si w kolejce gotowych tostw:
        Toast t = finishedQueue->get();
        // Sprawdzenie, czy tosty pojawiaj si we waciwej
        // kolejnoci i czy s posmarowane demem:
        if(t.getId() != counter++ ||
           t.getStatus() != "z demem") {
          cout << ">>>> Bd: " << t << endl;
          exit(1);
        } else
          cout << "Mniam! " << t << endl;
      }
    } catch(Interrupted_Exception&) { /* Wyjcie */ }
    cout << "Konsument najedzony" << endl;
  }
};

int main() {
  srand(time(0)); // Inicjalizacja generatora pseudolosowego
  try {
    ToastQueue dryQueue(new TQueue<Toast>),
               butteredQueue(new TQueue<Toast>),
               finishedQueue(new TQueue<Toast>);
    cout << "Aby zakoczy, nacinij klawisz <Enter> " << endl;
    ThreadedExecutor executor;
    executor.execute(new Toaster(dryQueue));
    executor.execute(new Butterer(dryQueue,butteredQueue));
    executor.execute(
      new Jammer(butteredQueue, finishedQueue));
    executor.execute(new Eater(finishedQueue));
    cin.get();
    executor.interrupt();
  } catch(Synchronization_Exception& e) {
    cerr << e.what() << endl;
  }
} ///:~
