
//: C10:TemplateMethod.cpp
// Prosta demonstracja wzorca Metoda szablonowa
#include <iostream>
using namespace std;

class ApplicationFramework {
protected:
  virtual void customize1() = 0;
  virtual void customize2() = 0;
public:
  void templateMethod() {
    for(int i = 0; i < 5; i++) {
      customize1();
      customize2();
    }
  }
};

// Utworzenie nowej "aplikacji":
class MyApp : public ApplicationFramework {
protected:
  void customize1() { cout << "Hello "; }
  void customize2() { cout << "world!" << endl; }
};

int main() {
  MyApp app;
  app.templateMethod();
} ///:~
