
//: C10:Strategy.cpp
// Wzorzec projektowy Strategia
#include <iostream>
using namespace std;

class NameStrategy {
public:
  virtual void greet() = 0;
};

class SayHi : public NameStrategy {
public:
  void greet() {
    cout << "Czoem! Jak leci?" << endl;
  }
};

class Ignore : public NameStrategy {
public:
  void greet() {
    cout << "(Udaj, e Ci nie widz)" << endl;
  }
};

class Admission : public NameStrategy {
public:
  void greet() {
    cout << "Przepraszam, zapomniaem, jak si nazywasz." << endl;
  }
};

// "Kontekst" sterujcy strategi:
class Context {
  NameStrategy& strategy;
public:
  Context(NameStrategy& strat) : strategy(strat) {}
  void greet() { strategy.greet(); }
};

int main() {
  SayHi sayhi;
  Ignore ignore;
  Admission admission;
  Context c1(sayhi), c2(ignore), c3(admission);
  c1.greet();
  c2.greet();
  c3.greet();
} ///:~
