
//: C07:PriorityQueue3.cpp
// Ciekawsze zastosowanie kolejki priority_queue
#include <iostream>
#include <queue>
#include <string>
using namespace std;

class ToDoItem {
  char primary;
  int secondary;
  string item;
public:
  ToDoItem(string td, char pri ='A', int sec =1)
    : item(td), primary(pri), secondary(sec) {}
  friend bool operator<(
    const ToDoItem& x, const ToDoItem& y) {
    if(x.primary > y.primary)
      return true;
    if(x.primary == y.primary)
      if(x.secondary > y.secondary)
        return true;
    return false;
  }
  friend ostream&
  operator<<(ostream& os, const ToDoItem& td) {
    return os << td.primary << td.secondary
      << ": " << td.item;
  }
};

int main() {
  priority_queue<ToDoItem> toDoList;
  toDoList.push(ToDoItem("Wyrzuci mieci", 'C', 4));
  toDoList.push(ToDoItem("Nakarmi psa", 'A', 2));
  toDoList.push(ToDoItem("Nakarmi kanarka", 'B', 7));
  toDoList.push(ToDoItem("Skosi trawnik", 'C', 3));
  toDoList.push(ToDoItem("Podla kwiaty", 'A', 1));
  toDoList.push(ToDoItem("Nakarmi kota", 'B', 1));
  while(!toDoList.empty()) {
    cout << toDoList.top() << endl;
    toDoList.pop();
  }
} ///:~
