
//: C05:StaticAssert2.cpp
//{-g++}
#include <iostream>
using namespace std;

// Szablon i specjalizacja
template<bool>
struct StaticCheck {
   StaticCheck(...);
};

template<>
struct StaticCheck<false>{};

// Makro (generuje klas lokaln)
#define STATIC_CHECK(expr, msg) {              \
   class Error_##msg{};                        \
   sizeof((StaticCheck<expr>(Error_##msg()))); \
}

// Wykrywa konwersje zawajce
template<class To, class From>
To safe_cast(From from) {
   STATIC_CHECK(sizeof(From) <= sizeof(To),
                NarrowingConversion);
   return reinterpret_cast<To>(from);
}

int main() {
   void* p = 0;
   int i = safe_cast<int>(p);
   cout << "rzutowanie int OK\n";
//!   char c = safe_cast<char>(p);
} ///:~
