
//: C03:Rparse.h
#ifndef RPARSE_H
#define RPARSE_H
#include <cstddef>
#include <string>
#include <vector>
#include "../TestSuite/Test.h"
using std::size_t;
using std::string;
using std::vector;

class RparseTest : public TestSuite::Test {
  // Na sowa:
  vector<string> strings;
public:
  void parseForData() {
    // Znaki ';' bd ogranicznikami 
    string s("sens.;teraz;mie;powinno;to;kocu;W");
    // Ostatni element acucha:
    int last = s.size();
    // Pocztek aktualnego sowa:
    size_t current = s.rfind(';');
    // Przejcie przez acuch wstecz:
    while(current != string::npos) {
      // Wstawienie kadego sowa do wektora.
      // Zmienna current jest aktualizowana przed kopiowaniem,
      // aby nie kopiowa ogranicznika:
      ++current;
      strings.push_back(s.substr(current, last - current));
      // Cofnicie si za znaleziony ogranicznik, ustawienie
      // zmiennej last na koniec nastpnego sowa:
      current -= 2;
      last = current + 1;
      // Znajd nastpny ogranicznik:
      current = s.rfind(';', current);
    }
    // Wybierz pierwsze sowo -- nie jest ono
    // poprzedzone ogranicznikiem.
    strings.push_back(s.substr(0, last));
  }
  void testData() {
    // Sprawd je w nowej kolejnoci:
    test_(strings[0] == "W");
    test_(strings[1] == "kocu");
    test_(strings[2] == "to");
    test_(strings[3] == "powinno");
    test_(strings[4] == "mie");
    test_(strings[5] == "teraz");
    test_(strings[6] == "sens.");
    string sentence;
    for(size_t i = 0; i < strings.size() - 1; i++)
      sentence += strings[i] += " ";
    // "Rcznie" wstaw ostatnie sowo, aby unikn dodatkowej spacji:
    sentence += strings[strings.size() - 1];
    test_(sentence == "W kocu to powinno mie teraz sens.");
  }
  void run() {
    parseForData();
    testData();
  }
};
#endif // RPARSE_H ///:~
