
//: C02:BuggedSearch.cpp {-xo}
//{L} ../TestSuite/Test
#include <cstdlib>
#include <ctime>
#include <cassert>
#include <fstream>
#include "../TestSuite/Test.h"
using namespace std;

// Jedynie ta funkcja zawiera bdy
int* binarySearch(int* beg, int* end, int what) {
  while(end - beg != 1) {
    if(*beg == what) return beg;
    int mid = (end - beg) / 2;
    if(what <= beg[mid]) end = beg + mid;
    else beg = beg + mid;
  }
  return 0;
}

class BinarySearchTest : public TestSuite::Test {
  enum { SZ = 10 };
  int* data;
  int max; // led najwiksz liczb
  int current; // aktualny numer nieuwzgldniony
               // uyty w notContained()
  // Znajd nastpn liczb niezawart w tablicy 
  int notContained() {
    while(data[current] + 1 == data[current + 1])
      ++current;
    if(current >= SZ) return max + 1;
    int retValue = data[current++] + 1;
    return retValue;
  }
  void setData() {
    data = new int[SZ];
    assert(!max);
    // Wartoci wejciowe z przyrostami o jeden. Zostaw cz
    // wartoci z indeksami parzystymi i nieparzystymi.
    for(int i = 0; i < SZ;
        rand() % 2 == 0 ? max += 1 : max += 2)
      data[i++] = max;
  }
  void testInBound() {
    // Sprawd pooenia nieparzystych i parzystych,
    // niezawartych i zawartych
    for(int i = SZ; --i >=0;)
      test_(binarySearch(data, data + SZ, data[i]));
    for(int i = notContained(); i < max;
        i = notContained())
      test_(!binarySearch(data, data + SZ, i));
  }
  void testOutBounds() {
    // Badaj wartoci mniejsze
    for(int i = data[0]; --i > data[0] - 100;)
      test_(!binarySearch(data, data + SZ, i));
    // Badaj wartoci wiksze
    for(int i = data[SZ - 1];
        ++i < data[SZ -1] + 100;)
      test_(!binarySearch(data, data + SZ, i));
  }
public:
  BinarySearchTest() { max = current = 0; }
  void run() {
    setData();
    testInBound();
    testOutBounds();
    delete [] data;
  }
};

int main() {
  srand(time(0));
  BinarySearchTest t;
  t.run();
  return t.report();
} ///:~
