/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.RetryRequest;

public class ClientConfig {
    private static final Filter DEFAULT_FILTER = new AddSeleniumUserAgent().andThen(new RetryRequest());
    private final URI baseUri;
    private final Duration connectionTimeout;
    private final Duration readTimeout;
    private final Filter filters;
    private final Proxy proxy;
    private final Credentials credentials;

    private ClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Filter filters, Proxy proxy, Credentials credentials) {
        this.baseUri = baseUri;
        this.connectionTimeout = Require.nonNegative("Connection timeout", connectionTimeout);
        this.readTimeout = Require.nonNegative("Read timeout", readTimeout);
        this.filters = Require.nonNull("Filters", filters);
        this.proxy = proxy;
        this.credentials = credentials;
    }

    public static ClientConfig defaultConfig() {
        return new ClientConfig(null, Duration.ofSeconds(10L), Duration.ofMinutes(3L), DEFAULT_FILTER, null, null);
    }

    public ClientConfig baseUri(URI baseUri) {
        return new ClientConfig(Require.nonNull("Base URI", baseUri), this.connectionTimeout, this.readTimeout, this.filters, this.proxy, this.credentials);
    }

    public ClientConfig baseUrl(URL baseUrl) {
        try {
            return this.baseUri(Require.nonNull("Base URL", baseUrl).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public URL baseUrl() {
        try {
            return this.baseUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientConfig connectionTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, Require.nonNull("Connection timeout", timeout), this.readTimeout, this.filters, this.proxy, this.credentials);
    }

    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig readTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, Require.nonNull("Read timeout", timeout), this.filters, this.proxy, this.credentials);
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public ClientConfig withFilter(Filter filter) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, filter == null ? DEFAULT_FILTER : filter.andThen(DEFAULT_FILTER), this.proxy, this.credentials);
    }

    public Filter filter() {
        return this.filters;
    }

    public ClientConfig proxy(Proxy proxy) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, Require.nonNull("Proxy", proxy), this.credentials);
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public ClientConfig authenticateAs(Credentials credentials) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, this.proxy, Require.nonNull("Credentials", credentials));
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public String toString() {
        return "ClientConfig{baseUri=" + this.baseUri + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", filters=" + this.filters + ", proxy=" + this.proxy + ", credentials=" + this.credentials + '}';
    }
}

