/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.grid.server.ServletRequestWrappingHttpRequest;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class JeeInterop {
    private JeeInterop() {
    }

    public static void copyResponse(HttpResponse from, HttpServletResponse to) {
        to.setStatus(from.getStatus());
        from.getHeaderNames().forEach(name -> from.getHeaders((String)name).forEach(value -> to.addHeader((String)name, (String)value)));
        try (InputStream in = (InputStream)from.getContent().get();
             ServletOutputStream out = to.getOutputStream();){
            ByteStreams.copy(in, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static HttpRequest toHttpRequest(HttpServletRequest source) {
        return new ServletRequestWrappingHttpRequest(source);
    }

    public static void execute(HttpHandler handler, HttpServletRequest request, HttpServletResponse response) {
        JeeInterop.copyResponse(handler.execute(JeeInterop.toHttpRequest(request)), response);
    }
}

