/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.remote.Browser;

@AutoService(value={WebDriverInfo.class})
public class EdgeDriverInfo
extends ChromiumDriverInfo {
    @Override
    public String getDisplayName() {
        return "Edge";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.EDGE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.EDGE.is(capabilities.getBrowserName()) || capabilities.getCapability("ms:edgeOptions") != null || capabilities.getCapability("edgeOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        try {
            EdgeDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(capabilities));
    }
}

