/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v95.network.model.ResourceType;
import org.openqa.selenium.devtools.v95.network.model.Response;
import org.openqa.selenium.json.JsonInput;

public class CachedResource {
    private final String url;
    private final ResourceType type;
    private final Optional<Response> response;
    private final Number bodySize;

    public CachedResource(String url, ResourceType type, Optional<Response> response, Number bodySize) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.response = response;
        this.bodySize = Objects.requireNonNull(bodySize, "bodySize is required");
    }

    public String getUrl() {
        return this.url;
    }

    public ResourceType getType() {
        return this.type;
    }

    public Optional<Response> getResponse() {
        return this.response;
    }

    public Number getBodySize() {
        return this.bodySize;
    }

    private static CachedResource fromJson(JsonInput input) {
        String url = null;
        ResourceType type = null;
        Optional<Response> response = Optional.empty();
        Number bodySize = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read((Type)((Object)ResourceType.class)));
                    continue block12;
                }
                case "response": {
                    response = Optional.ofNullable((Response)input.read((Type)((Object)Response.class)));
                    continue block12;
                }
                case "bodySize": {
                    bodySize = input.nextNumber();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CachedResource(url, type, response, bodySize);
    }
}

