/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.RandomSupplier;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleSumAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongSumAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import java.util.function.Supplier;

class SumAggregation
extends Aggregation {
    static final SumAggregation DEFAULT = new SumAggregation();

    private SumAggregation() {
    }

    @Override
    public <T> Aggregator<T> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        Supplier<ExemplarReservoir> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.fixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongSumAggregator(instrumentDescriptor, reservoirFactory);
            }
            case DOUBLE: {
                return new DoubleSumAggregator(instrumentDescriptor, reservoirFactory);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    public String toString() {
        return "SumAggregation";
    }
}

