/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.DirectivesUtil;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.ImplementingTypesChecker;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaTypeDirectivesChecker;
import graphql.schema.idl.SchemaTypeExtensionsChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionTypesChecker;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.DirectiveIllegalLocationError;
import graphql.schema.idl.errors.MissingInterfaceTypeError;
import graphql.schema.idl.errors.MissingScalarImplementationError;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.MissingTypeResolverError;
import graphql.schema.idl.errors.NonUniqueArgumentError;
import graphql.schema.idl.errors.NonUniqueDirectiveError;
import graphql.schema.idl.errors.NonUniqueNameError;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Internal
public class SchemaTypeChecker {
    public List<GraphQLError> checkTypeRegistry(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        this.checkForMissingTypes(errors, typeRegistry);
        SchemaTypeExtensionsChecker typeExtensionsChecker = new SchemaTypeExtensionsChecker();
        typeExtensionsChecker.checkTypeExtensions(errors, typeRegistry);
        ImplementingTypesChecker implementingTypesChecker = new ImplementingTypesChecker();
        implementingTypesChecker.checkImplementingTypes(errors, typeRegistry);
        UnionTypesChecker unionTypesChecker = new UnionTypesChecker();
        unionTypesChecker.checkUnionType(errors, typeRegistry);
        SchemaExtensionsChecker.checkSchemaInvariants(errors, typeRegistry);
        this.checkScalarImplementationsArePresent(errors, typeRegistry, wiring);
        this.checkTypeResolversArePresent(errors, typeRegistry, wiring);
        this.checkFieldsAreSensible(errors, typeRegistry);
        this.checkDirectiveDefinitions(typeRegistry, errors);
        SchemaTypeDirectivesChecker directivesChecker = new SchemaTypeDirectivesChecker(typeRegistry, wiring);
        directivesChecker.checkTypeDirectives(errors);
        return errors;
    }

    private void checkForMissingTypes(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        List<ObjectTypeExtensionDefinition> typeExtensions = typeRegistry.objectTypeExtensions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        typeExtensions.forEach(typeExtension -> {
            List<Type> implementsTypes = typeExtension.getImplements();
            implementsTypes.forEach(this.checkInterfaceTypeExists(typeRegistry, errors, (TypeDefinition)typeExtension));
            this.checkFieldTypesPresent(typeRegistry, errors, (TypeDefinition)typeExtension, typeExtension.getFieldDefinitions());
        });
        Map<String, TypeDefinition> typesMap = typeRegistry.types();
        List<ObjectTypeDefinition> objectTypes = this.filterTo(typesMap, ObjectTypeDefinition.class);
        objectTypes.forEach(objectType -> {
            List<Type> implementsTypes = objectType.getImplements();
            implementsTypes.forEach(this.checkInterfaceTypeExists(typeRegistry, errors, (TypeDefinition)objectType));
            this.checkFieldTypesPresent(typeRegistry, errors, (TypeDefinition)objectType, objectType.getFieldDefinitions());
        });
        List<InterfaceTypeDefinition> interfaceTypes = this.filterTo(typesMap, InterfaceTypeDefinition.class);
        interfaceTypes.forEach(interfaceType -> {
            List<FieldDefinition> fields = interfaceType.getFieldDefinitions();
            this.checkFieldTypesPresent(typeRegistry, errors, (TypeDefinition)interfaceType, fields);
        });
        List<UnionTypeDefinition> unionTypes = this.filterTo(typesMap, UnionTypeDefinition.class);
        unionTypes.forEach(unionType -> {
            List<Type> memberTypes = unionType.getMemberTypes();
            memberTypes.forEach(this.checkTypeExists("union member", typeRegistry, errors, (TypeDefinition)unionType));
        });
        List<InputObjectTypeDefinition> inputTypes = this.filterTo(typesMap, InputObjectTypeDefinition.class);
        inputTypes.forEach(inputType -> {
            List<InputValueDefinition> inputValueDefinitions = inputType.getInputValueDefinitions();
            List<Type> inputValueTypes = inputValueDefinitions.stream().map(InputValueDefinition::getType).collect(Collectors.toList());
            inputValueTypes.forEach(this.checkTypeExists("input value", typeRegistry, errors, (TypeDefinition)inputType));
        });
    }

    private void checkDirectiveDefinitions(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors) {
        ArrayList<DirectiveDefinition> directiveDefinitions = new ArrayList<DirectiveDefinition>(typeRegistry.getDirectiveDefinitions().values());
        directiveDefinitions.forEach(directiveDefinition -> {
            List<InputValueDefinition> arguments = directiveDefinition.getInputValueDefinitions();
            SchemaTypeChecker.checkNamedUniqueness(errors, arguments, InputValueDefinition::getName, (name, arg) -> new NonUniqueNameError((DirectiveDefinition)directiveDefinition, (InputValueDefinition)arg));
            List<Type> inputValueTypes = arguments.stream().map(InputValueDefinition::getType).collect(Collectors.toList());
            inputValueTypes.forEach(this.checkTypeExists(typeRegistry, errors, "directive definition", (Node)directiveDefinition, directiveDefinition.getName()));
            directiveDefinition.getDirectiveLocations().forEach(directiveLocation -> {
                String locationName = directiveLocation.getName();
                try {
                    Introspection.DirectiveLocation.valueOf(locationName);
                }
                catch (IllegalArgumentException e) {
                    errors.add(new DirectiveIllegalLocationError((DirectiveDefinition)directiveDefinition, locationName));
                }
            });
        });
    }

    private void checkScalarImplementationsArePresent(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
        typeRegistry.scalars().forEach((scalarName, scalarTypeDefinition) -> {
            ScalarWiringEnvironment environment;
            WiringFactory wiringFactory = wiring.getWiringFactory();
            if (!wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, (ScalarTypeDefinition)scalarTypeDefinition, Collections.emptyList())) && !wiring.getScalars().containsKey(scalarName)) {
                errors.add(new MissingScalarImplementationError((String)scalarName));
            }
        });
    }

    private void checkFieldsAreSensible(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        Map<String, TypeDefinition> typesMap = typeRegistry.types();
        Map<String, DirectiveDefinition> directiveDefinitionMap = typeRegistry.getDirectiveDefinitions();
        List<ObjectTypeDefinition> objectTypes = this.filterTo(typesMap, ObjectTypeDefinition.class);
        objectTypes.forEach(objectType -> this.checkObjTypeFields(errors, (ObjectTypeDefinition)objectType, objectType.getFieldDefinitions(), directiveDefinitionMap));
        List<InterfaceTypeDefinition> interfaceTypes = this.filterTo(typesMap, InterfaceTypeDefinition.class);
        interfaceTypes.forEach(interfaceType -> this.checkInterfaceFields(errors, (InterfaceTypeDefinition)interfaceType, interfaceType.getFieldDefinitions(), directiveDefinitionMap));
        List<EnumTypeDefinition> enumTypes = this.filterTo(typesMap, EnumTypeDefinition.class);
        enumTypes.forEach(enumType -> this.checkEnumValues(errors, (EnumTypeDefinition)enumType, enumType.getEnumValueDefinitions(), directiveDefinitionMap));
        List<InputObjectTypeDefinition> inputTypes = this.filterTo(typesMap, InputObjectTypeDefinition.class);
        inputTypes.forEach(inputType -> this.checkInputValues(errors, (InputObjectTypeDefinition)inputType, inputType.getInputValueDefinitions(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, directiveDefinitionMap));
    }

    private void checkObjTypeFields(List<GraphQLError> errors, ObjectTypeDefinition typeDefinition, List<FieldDefinition> fieldDefinitions, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors, fieldDefinitions, FieldDefinition::getName, (name, fieldDef) -> new NonUniqueNameError((TypeDefinition)typeDefinition, (FieldDefinition)fieldDef));
        fieldDefinitions.forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getInputValueDefinitions(), InputValueDefinition::getName, (name, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)typeDefinition, (FieldDefinition)fld, (String)name)));
        for (FieldDefinition fieldDefinition : fieldDefinitions) {
            List<Directive> directives = fieldDefinition.getDirectives();
            List<Directive> nonRepeatableDirectives = DirectivesUtil.nonRepeatableDirectivesOnly(directiveDefinitionMap, directives);
            SchemaTypeChecker.checkNamedUniqueness(errors, nonRepeatableDirectives, Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)typeDefinition, fieldDefinition, (String)directiveName));
        }
        fieldDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)typeDefinition, (FieldDefinition)fld, (String)argumentName))));
    }

    private void checkInterfaceFields(List<GraphQLError> errors, InterfaceTypeDefinition interfaceType, List<FieldDefinition> fieldDefinitions, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors, fieldDefinitions, FieldDefinition::getName, (name, fieldDef) -> new NonUniqueNameError((TypeDefinition)interfaceType, (FieldDefinition)fieldDef));
        fieldDefinitions.forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getInputValueDefinitions(), InputValueDefinition::getName, (name, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)interfaceType, (FieldDefinition)fld, (String)name)));
        fieldDefinitions.forEach(fieldDefinition -> {
            List<Directive> directives = fieldDefinition.getDirectives();
            List<Directive> nonRepeatableDirectives = DirectivesUtil.nonRepeatableDirectivesOnly(directiveDefinitionMap, directives);
            SchemaTypeChecker.checkNamedUniqueness(errors, nonRepeatableDirectives, Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)interfaceType, (FieldDefinition)fieldDefinition, (String)directiveName));
            directives.forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)interfaceType, (FieldDefinition)fieldDefinition, (String)argumentName)));
        });
    }

    private void checkEnumValues(List<GraphQLError> errors, EnumTypeDefinition enumType, List<EnumValueDefinition> enumValueDefinitions, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors, enumValueDefinitions, EnumValueDefinition::getName, (name, inputValueDefinition) -> new NonUniqueNameError((TypeDefinition)enumType, (EnumValueDefinition)inputValueDefinition));
        for (EnumValueDefinition enumValueDefinition : enumValueDefinitions) {
            List<Directive> directives = enumValueDefinition.getDirectives();
            List<Directive> nonRepeatableDirectives = DirectivesUtil.nonRepeatableDirectivesOnly(directiveDefinitionMap, directives);
            SchemaTypeChecker.checkNamedUniqueness(errors, nonRepeatableDirectives, Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)enumType, enumValueDefinition, (String)directiveName));
        }
        enumValueDefinitions.forEach(enumValue -> enumValue.getDirectives().forEach(directive -> {
            BiFunction<String, Argument, NonUniqueArgumentError> errorFunction = (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)enumType, (EnumValueDefinition)enumValue, (String)argumentName);
            SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, errorFunction);
        }));
    }

    private void checkInputValues(List<GraphQLError> errors, InputObjectTypeDefinition inputType, List<InputValueDefinition> inputValueDefinitions, Introspection.DirectiveLocation directiveLocation, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors, inputValueDefinitions, InputValueDefinition::getName, (name, inputValueDefinition) -> {
            InputObjectTypeDefinition as = inputType;
            return new NonUniqueNameError(as, (InputValueDefinition)inputValueDefinition);
        });
        for (InputValueDefinition inputValueDefinition2 : inputValueDefinitions) {
            List<Directive> directives = inputValueDefinition2.getDirectives();
            List<Directive> nonRepeatableDirectives = DirectivesUtil.nonRepeatableDirectivesOnly(directiveDefinitionMap, directives);
            SchemaTypeChecker.checkNamedUniqueness(errors, nonRepeatableDirectives, Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)inputType, inputValueDefinition2, (String)directiveName));
        }
        inputValueDefinitions.forEach(inputValueDef -> inputValueDef.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)inputType, (InputValueDefinition)inputValueDef, (String)argumentName))));
    }

    static <T, E extends GraphQLError> void checkNamedUniqueness(List<GraphQLError> errors, List<T> listOfNamedThings, Function<T, String> namer, BiFunction<String, T, E> errorFunction) {
        LinkedHashSet names = new LinkedHashSet();
        listOfNamedThings.forEach(thing -> {
            String name = (String)namer.apply(thing);
            if (names.contains(name)) {
                errors.add((GraphQLError)errorFunction.apply(name, thing));
            } else {
                names.add(name);
            }
        });
    }

    private void checkTypeResolversArePresent(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
        Predicate<InterfaceTypeDefinition> noDynamicResolverForInterface = interaceTypeDef -> !wiring.getWiringFactory().providesTypeResolver(new InterfaceWiringEnvironment(typeRegistry, (InterfaceTypeDefinition)interaceTypeDef));
        Predicate<UnionTypeDefinition> noDynamicResolverForUnion = unionTypeDef -> !wiring.getWiringFactory().providesTypeResolver(new UnionWiringEnvironment(typeRegistry, (UnionTypeDefinition)unionTypeDef));
        Predicate<TypeDefinition> noTypeResolver = typeDefinition -> !wiring.getTypeResolvers().containsKey(typeDefinition.getName());
        Consumer<TypeDefinition> addError = typeDefinition -> errors.add(new MissingTypeResolverError((TypeDefinition)typeDefinition));
        typeRegistry.types().values().stream().filter(typeDef -> typeDef instanceof InterfaceTypeDefinition).map(InterfaceTypeDefinition.class::cast).filter(noDynamicResolverForInterface).filter(noTypeResolver).forEach(addError);
        typeRegistry.types().values().stream().filter(typeDef -> typeDef instanceof UnionTypeDefinition).map(UnionTypeDefinition.class::cast).filter(noDynamicResolverForUnion).filter(noTypeResolver).forEach(addError);
    }

    private void checkFieldTypesPresent(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, TypeDefinition typeDefinition, List<FieldDefinition> fields) {
        List<Type> fieldTypes = fields.stream().map(FieldDefinition::getType).collect(Collectors.toList());
        fieldTypes.forEach(this.checkTypeExists("field", typeRegistry, errors, typeDefinition));
        List<Type> fieldInputValues = fields.stream().map(f -> f.getInputValueDefinitions().stream().map(InputValueDefinition::getType).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        fieldInputValues.forEach(this.checkTypeExists("field input", typeRegistry, errors, typeDefinition));
    }

    private Consumer<Type> checkTypeExists(String typeOfType, TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, TypeDefinition typeDefinition) {
        return t -> {
            TypeName unwrapped = TypeInfo.typeInfo(t).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors.add(new MissingTypeError(typeOfType, typeDefinition, unwrapped));
            }
        };
    }

    private Consumer<Type> checkTypeExists(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, String typeOfType, Node element, String elementName) {
        return ivType -> {
            TypeName unwrapped = TypeInfo.typeInfo(ivType).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors.add(new MissingTypeError(typeOfType, element, elementName, unwrapped));
            }
        };
    }

    private Consumer<? super Type> checkInterfaceTypeExists(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, TypeDefinition typeDefinition) {
        return t -> {
            TypeInfo typeInfo = TypeInfo.typeInfo(t);
            TypeName unwrapped = typeInfo.getTypeName();
            Optional<TypeDefinition> type = typeRegistry.getType(unwrapped);
            if (!type.isPresent()) {
                errors.add(new MissingInterfaceTypeError("interface", typeDefinition, unwrapped));
            } else if (!(type.get() instanceof InterfaceTypeDefinition)) {
                errors.add(new MissingInterfaceTypeError("interface", typeDefinition, unwrapped));
            }
        };
    }

    private <T extends TypeDefinition> List<T> filterTo(Map<String, TypeDefinition> types, Class<? extends T> clazz) {
        return types.values().stream().filter(t -> clazz.equals(t.getClass())).map(clazz::cast).collect(Collectors.toList());
    }
}

