/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.FetchedValue;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.ResolveType;
import graphql.execution.nextgen.FetchedValueAnalysis;
import graphql.execution.nextgen.FetchedValueAnalyzer;
import graphql.execution.nextgen.FieldSubSelection;
import graphql.execution.nextgen.ResultNodesCreator;
import graphql.execution.nextgen.ValueFetcher;
import graphql.execution.nextgen.result.ExecutionResultNode;
import graphql.execution.nextgen.result.ResolvedValue;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Internal
public class ExecutionStrategyUtil {
    ExecutionStepInfoFactory executionStepInfoFactory = new ExecutionStepInfoFactory();
    FetchedValueAnalyzer fetchedValueAnalyzer = new FetchedValueAnalyzer();
    ValueFetcher valueFetcher = new ValueFetcher();
    ResultNodesCreator resultNodesCreator = new ResultNodesCreator();
    ResolveType resolveType = new ResolveType();
    FieldCollector fieldCollector = new FieldCollector();

    public List<CompletableFuture<ExecutionResultNode>> fetchSubSelection(ExecutionContext executionContext, FieldSubSelection fieldSubSelection) {
        List<CompletableFuture<FetchedValueAnalysis>> fetchedValueAnalysisList = this.fetchAndAnalyze(executionContext, fieldSubSelection);
        return this.fetchedValueAnalysisToNodesAsync(fetchedValueAnalysisList);
    }

    private List<CompletableFuture<FetchedValueAnalysis>> fetchAndAnalyze(ExecutionContext context, FieldSubSelection fieldSubSelection) {
        return ImmutableKit.map(fieldSubSelection.getMergedSelectionSet().getSubFieldsList(), mergedField -> this.fetchAndAnalyzeField(context, fieldSubSelection.getSource(), fieldSubSelection.getLocalContext(), (MergedField)mergedField, fieldSubSelection.getExecutionStepInfo()));
    }

    private CompletableFuture<FetchedValueAnalysis> fetchAndAnalyzeField(ExecutionContext context, Object source, Object localContext, MergedField mergedField, ExecutionStepInfo executionStepInfo) {
        ExecutionStepInfo newExecutionStepInfo = this.executionStepInfoFactory.newExecutionStepInfoForSubField(context, mergedField, executionStepInfo);
        return this.valueFetcher.fetchValue(context, source, localContext, mergedField, newExecutionStepInfo).thenApply(fetchValue -> this.analyseValue(context, (FetchedValue)fetchValue, newExecutionStepInfo));
    }

    private List<CompletableFuture<ExecutionResultNode>> fetchedValueAnalysisToNodesAsync(List<CompletableFuture<FetchedValueAnalysis>> list) {
        return Async.map(list, fetchedValueAnalysis -> this.resultNodesCreator.createResultNode((FetchedValueAnalysis)fetchedValueAnalysis));
    }

    public List<ExecutionResultNode> fetchedValueAnalysisToNodes(List<FetchedValueAnalysis> fetchedValueAnalysisList) {
        return ImmutableKit.map(fetchedValueAnalysisList, fetchedValueAnalysis -> this.resultNodesCreator.createResultNode((FetchedValueAnalysis)fetchedValueAnalysis));
    }

    private FetchedValueAnalysis analyseValue(ExecutionContext executionContext, FetchedValue fetchedValue, ExecutionStepInfo executionInfo) {
        FetchedValueAnalysis fetchedValueAnalysis = this.fetchedValueAnalyzer.analyzeFetchedValue(executionContext, fetchedValue, executionInfo);
        return fetchedValueAnalysis;
    }

    public FieldSubSelection createFieldSubSelection(ExecutionContext executionContext, ExecutionStepInfo executionInfo, ResolvedValue resolvedValue) {
        MergedField field = executionInfo.getField();
        Object source = resolvedValue.getCompletedValue();
        Object localContext = resolvedValue.getLocalContext();
        GraphQLOutputType sourceType = executionInfo.getUnwrappedNonNullType();
        GraphQLObjectType resolvedObjectType = this.resolveType.resolveType(executionContext, field, source, executionInfo.getArguments(), sourceType);
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, executionInfo.getField());
        ExecutionStepInfo newExecutionStepInfoWithResolvedType = executionInfo.changeTypeWithPreservedNonNull(resolvedObjectType);
        return FieldSubSelection.newFieldSubSelection().source(source).localContext(localContext).mergedSelectionSet(subFields).executionInfo(newExecutionStepInfoWithResolvedType).build();
    }
}

